/*
 * Decompiled with CFR 0.152.
 */
package net.mosquito.mosquievent.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.mosquito.mosquievent.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "mosquievent", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.BAGUETTE);
        this.simpleItem(ModItems.DONUT);
        this.simpleItem(ModItems.PATE_PAIN);
        this.simpleItem(ModItems.MUSIC_DISC_DOIGBY);
        this.simpleItem(ModItems.MUSIC_DISC_LAVA_CHICKEN);
        this.simpleItem(ModItems.PETITPOTE);
        this.simpleItem(ModItems.POLLO);
        this.simpleItem(ModItems.LAXATIF);
        this.simpleItem(ModItems.CACA);
        this.threeDItem(ModItems.HAMMER_JUDGE);
        this.threeDItem(ModItems.CARTILITE_SWORD);
        this.simpleItem(ModItems.CARTILITE_POWDER);
        this.simpleItem(ModItems.CARTILITE_INGOT);
        this.handheldItem(ModItems.CARTILITE_AXE);
        this.handheldItem(ModItems.CARTILITE_HOE);
        this.handheldItem(ModItems.CARTILITE_SHOVEL);
        this.handheldItem(ModItems.CARTILITE_PICKAXE);
        this.handheldItem(ModItems.BLAHAJ_BUCKET);
        this.handheldItem(ModItems.DUCK_SPAWN_EGG);
        this.handheldItem(ModItems.DUCK_EGG);
        this.handheldItem(ModItems.QUOKKA_SPAWN_EGG);
        this.handheldItem(ModItems.DUCK_ICON);
        this.handheldItem(ModItems.BULLET_TEXTURE);
        this.handheldItem(ModItems.BULLET);
        this.threeDItem(ModItems.SNIPER);
        this.trimmedArmorItem(ModItems.CACA_PANTS);
        this.trimmedArmorItem(ModItems.CACA_BOOT);
        this.trimmedArmorItem(ModItems.CACA_CHEST);
        this.trimmedArmorItem(ModItems.CACA_HAT);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("mosquievent", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder threeDItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("mosquievent", "item/" + item.getId().m_135815_() + "_3d"));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("mosquievent", "item/" + item.getId().m_135815_()));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "mosquievent";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + String.valueOf(armorItem);
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("mosquievent", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("mosquievent", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("mosquievent", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

