/*
 * Decompiled with CFR 0.152.
 */
package net.mosquito.mosquievent.entity.custom;

import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mosquito.mosquievent.entity.BlahajVariant;
import net.mosquito.mosquievent.entity.ModEntities;
import net.mosquito.mosquievent.entity.control.BlahajMoveControl;
import net.mosquito.mosquievent.item.ModItems;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BlahajEntity
extends Animal
implements GeoAnimatable,
Bucketable {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(BlahajEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BlahajEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BlahajEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new BlahajMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.2, 10));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, false));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 1.25).m_22268_(Attributes.f_22277_, 30.0).m_22265_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (state.isMoving() && state.getLimbSwingAmount() > 0.3f) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.blahaj.animation", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animation.blahaj.animation", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12289_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12294_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12292_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42447_ && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack bucketMob = new ItemStack((ItemLike)ModItems.BLAHAJ_BUCKET.get());
            this.m_6872_(bucketMob);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketMob);
            }
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, bucketMob);
            } else if (!player.m_150109_().m_36054_(bucketMob)) {
                player.m_36176_(bucketMob, false);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_41720_() == ModItems.BLAHAJ_BUCKET.get()) {
            this.m_5496_(SoundEvents.f_11779_, 1.0f, 1.0f);
            ItemStack bucket = new ItemStack((ItemLike)Items.f_42446_);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucket);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.spawnAtLocation(serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
            }
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, bucket);
            } else if (!player.m_150109_().m_36054_(bucket)) {
                player.m_36176_(bucket, false);
            }
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        this.m_7380_(tag);
    }

    public void m_142278_(CompoundTag pTag) {
        this.m_7378_(pTag);
    }

    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BLAHAJ_BUCKET.get());
        this.m_6872_(stack);
        return stack;
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public BlahajVariant getVariant() {
        return BlahajVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(BlahajVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128451_("Variant"));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void spawnAtLocation(ServerLevel level, double x, double y, double z) {
        BlahajEntity entity = (BlahajEntity)((EntityType)ModEntities.BLAHAJ.get()).m_20615_((Level)level);
        if (entity != null) {
            entity.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
            level.m_7967_((Entity)entity);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        BlahajVariant variant = (BlahajVariant)((Object)Util.m_214670_((Object[])BlahajVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        BlahajEntity baby = (BlahajEntity)((EntityType)ModEntities.BLAHAJ.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.setVariant((BlahajVariant)((Object)Util.m_214670_((Object[])BlahajVariant.values(), (RandomSource)this.f_19796_)));
        }
        return baby;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.BAGUETTE.get());
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19998_((ItemLike)Items.f_42695_);
    }

    public static boolean checkBlahajSpawn(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        boolean canSpawn;
        float spawnChance = 0.2f;
        boolean onLand = pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184228_);
        boolean inWater = pLevel.m_6425_(pPos).m_205070_(FluidTags.f_13131_);
        boolean bl = canSpawn = onLand || inWater;
        if (canSpawn && pRandom.m_188501_() < spawnChance) {
            System.out.println("Spawn possible \u00e0 " + String.valueOf(pPos));
            BlahajEntity mob = (BlahajEntity)((EntityType)ModEntities.BLAHAJ.get()).m_20615_((Level)pLevel);
            if (mob != null) {
                mob.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
                mob.m_6518_((ServerLevelAccessor)((ServerLevel)pLevel), pLevel.m_6436_(pPos), pSpawnType, null, null);
                ((Level)pLevel).m_7967_((Entity)mob);
            }
        }
        return canSpawn;
    }
}

