/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractSittableBlock
extends HorizontalDirectionalBlock {
    private final BlockState baseBlockState = this.m_49966_();
    private final Block baseBlock = this.baseBlockState.m_60734_();
    public float height;

    public AbstractSittableBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
        this.height = 0.36f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.m_8125_() : ctx.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (player.m_5833_() || player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        List active = world.m_6443_(ChairEntity.class, new AABB(pos), Entity::m_20160_);
        if (active == null) {
            return InteractionResult.FAIL;
        }
        ArrayList hasPassenger = new ArrayList();
        active.forEach(chairEntity -> hasPassenger.add(chairEntity.m_146895_()));
        if (!active.isEmpty() && hasPassenger.stream().anyMatch(Entity::m_142389_)) {
            return InteractionResult.FAIL;
        }
        if (!active.isEmpty()) {
            hasPassenger.forEach(Entity::m_8127_);
            return InteractionResult.SUCCESS;
        }
        if (this.sitEntity(world, pos, state, (Entity)player) == InteractionResult.SUCCESS) {
            if (!(state.m_60734_() instanceof BasicToiletBlock)) {
                player.m_36220_(Statistics.CHAIR_USED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult sitEntity(Level world, BlockPos pos, BlockState state, Entity entityToSit) {
        double pz;
        double px;
        if (state.m_60734_() instanceof BasicChairBlock) {
            Direction direction = (Direction)state.m_61143_((Property)f_54117_);
            if (((Boolean)state.m_61143_((Property)BasicChairBlock.TUCKED)).booleanValue()) {
                switch (direction) {
                    case EAST: {
                        px = (double)pos.m_123341_() + 0.1;
                        pz = (double)pos.m_123343_() + 0.5;
                        break;
                    }
                    case WEST: {
                        px = (double)pos.m_123341_() + 0.9;
                        pz = (double)pos.m_123343_() + 0.5;
                        break;
                    }
                    case SOUTH: {
                        px = (double)pos.m_123341_() + 0.5;
                        pz = (double)pos.m_123343_() + 0.1;
                        break;
                    }
                    default: {
                        px = (double)pos.m_123341_() + 0.5;
                        pz = (double)pos.m_123343_() + 0.9;
                        break;
                    }
                }
            } else {
                px = (double)pos.m_123341_() + 0.5;
                pz = (double)pos.m_123343_() + 0.5;
            }
        } else {
            px = (double)pos.m_123341_() + 0.5;
            pz = (double)pos.m_123343_() + 0.5;
        }
        double py = (float)pos.m_123342_() + this.height;
        float yaw = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122435_();
        ChairEntity chairEntity = (ChairEntity)Entities.CHAIR.m_20615_(world);
        chairEntity.m_7678_(px, py, pz, yaw, 0.0f);
        chairEntity.m_20242_(true);
        chairEntity.m_20225_(true);
        chairEntity.m_6842_(false);
        chairEntity.m_20331_(true);
        chairEntity.m_21557_(true);
        chairEntity.m_147244_(true);
        chairEntity.m_5616_(yaw);
        chairEntity.m_146922_(yaw);
        chairEntity.m_5618_(yaw);
        if (world.m_7967_((Entity)chairEntity)) {
            entityToSit.m_7998_((Entity)chairEntity, true);
            entityToSit.m_146922_(yaw);
            entityToSit.m_5616_(yaw);
            chairEntity.m_146922_(yaw);
            chairEntity.m_5618_(yaw);
            chairEntity.m_5616_(yaw);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        List active = world.m_6443_(ChairEntity.class, new AABB(pos), Entity::m_20160_);
        if (active == null || !active.isEmpty()) {
            return;
        }
        if (entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof ChairEntity) {
            return;
        }
        if (!PaladinFurnitureMod.getPFMConfig().doMobsSitOnChairs()) {
            return;
        }
        this.sitEntity(world, pos, state, entity);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static boolean isWoodBased(BlockState state) {
        NoteBlockInstrument instrument = state.m_280603_();
        SoundType soundGroup = state.m_60827_();
        return soundGroup == SoundType.f_243772_ || soundGroup == SoundType.f_56745_ || soundGroup == SoundType.f_271497_ || soundGroup == SoundType.f_56736_ || soundGroup == SoundType.f_244244_ || instrument == NoteBlockInstrument.BASS;
    }
}

