/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ArmChairBlock;
import com.unlikepaladin.pfm.blocks.ArmChairShape;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArmChairColoredBlock
extends ArmChairBlock
implements DyeableFurnitureBlock {
    public static final EnumProperty<ArmChairShape> SHAPE = EnumProperty.m_61587_((String)"shape", ArmChairShape.class);
    private static final List<FurnitureBlock> COLORED_ARMCHAIRS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    protected static final VoxelShape STANDARD = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.5, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)12.0, (double)0.0, (double)1.5, (double)14.5, (double)3.0, (double)4.0), ArmChairColoredBlock.m_49796_((double)1.0, (double)0.0, (double)1.5, (double)3.5, (double)3.0, (double)4.0), ArmChairColoredBlock.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.5, (double)3.0, (double)14.5), ArmChairColoredBlock.m_49796_((double)6.6, (double)2.0, (double)13.0, (double)16.3, (double)13.71, (double)16.0), ArmChairColoredBlock.m_49796_((double)6.6, (double)2.0, (double)0.0, (double)16.3, (double)13.71, (double)3.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)2.0, (double)3.0, (double)16.3, (double)10.51, (double)13.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)10.5, (double)3.0, (double)5.3, (double)25.51, (double)13.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)2.0, (double)13.0, (double)6.6, (double)25.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)2.0, (double)0.0, (double)6.6, (double)25.51, (double)3.0)});
    protected static final VoxelShape MIDDLE = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)0.0, (double)2.0, (double)0.3, (double)16.0, (double)9.51, (double)16.0), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)0.0, (double)9.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3), ArmChairColoredBlock.m_49796_((double)0.0, (double)9.5, (double)5.3, (double)16.0, (double)10.5, (double)16.0)});
    protected static final VoxelShape OUTER = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)10.51, (double)15.7), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)0.0, (double)10.5, (double)10.7, (double)5.3, (double)25.51, (double)15.7), ArmChairColoredBlock.m_49796_((double)0.3, (double)2.0, (double)15.7, (double)5.3, (double)25.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)5.3, (double)2.0, (double)15.7, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)12.5, (double)0.0, (double)1.7, (double)15.0, (double)3.0, (double)4.2), ArmChairColoredBlock.m_49796_((double)1.0, (double)0.0, (double)11.7, (double)3.5, (double)3.0, (double)14.2)});
    protected static final VoxelShape LEFT_EDGE = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)1.5, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)3.5), ArmChairColoredBlock.m_49796_((double)0.0, (double)2.0, (double)6.6, (double)3.0, (double)13.71, (double)16.0), ArmChairColoredBlock.m_49796_((double)3.0, (double)2.0, (double)0.3, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)3.0, (double)10.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3), ArmChairColoredBlock.m_49796_((double)0.0, (double)2.0, (double)0.3, (double)3.0, (double)25.51, (double)6.6)});
    protected static final VoxelShape RIGHT_EDGE = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)12.5, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)12.5, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.5), ArmChairColoredBlock.m_49796_((double)13.0, (double)2.0, (double)6.6, (double)16.0, (double)13.71, (double)16.0), ArmChairColoredBlock.m_49796_((double)0.0, (double)2.0, (double)0.3, (double)13.0, (double)10.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)0.0, (double)10.5, (double)0.3, (double)13.0, (double)25.51, (double)5.3), ArmChairColoredBlock.m_49796_((double)13.0, (double)2.0, (double)0.3, (double)16.0, (double)25.51, (double)6.6)});
    protected static final VoxelShape INNER = Shapes.m_83124_((VoxelShape)ArmChairColoredBlock.m_49796_((double)12.5, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.m_49796_((double)1.0, (double)0.0, (double)1.5, (double)3.5, (double)3.0, (double)4.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)2.0, (double)0.3, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)10.5, (double)5.3, (double)5.3, (double)25.51, (double)16.0), ArmChairColoredBlock.m_49796_((double)0.3, (double)10.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3)});
    protected static final VoxelShape STANDARD_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, STANDARD);
    protected static final VoxelShape STANDARD_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, STANDARD);
    protected static final VoxelShape STANDARD_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, STANDARD);
    protected static final VoxelShape MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, MIDDLE);
    protected static final VoxelShape MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, MIDDLE);
    protected static final VoxelShape MIDDLE_WEST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, MIDDLE);
    protected static final VoxelShape OUTER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, OUTER);
    protected static final VoxelShape OUTER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, OUTER);
    protected static final VoxelShape OUTER_WEST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, OUTER);
    protected static final VoxelShape LEFT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, LEFT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, RIGHT_EDGE);
    protected static final VoxelShape INNER_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, INNER);
    protected static final VoxelShape INNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, INNER);
    protected static final VoxelShape INNER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, INNER);

    public ArmChairColoredBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)ArmChairShape.STRAIGHT)));
        if (this.getClass().isAssignableFrom(ArmChairColoredBlock.class)) {
            COLORED_ARMCHAIRS.add(new FurnitureBlock((Block)this, "arm_chair"));
        }
        this.color = color;
    }

    public static Stream<FurnitureBlock> streamArmChairColored() {
        return COLORED_ARMCHAIRS.stream();
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        ArmChairShape shape = (ArmChairShape)((Object)state.m_61143_(SHAPE));
        switch (shape) {
            case STRAIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> STANDARD_NORTH;
                    case Direction.SOUTH -> STANDARD_SOUTH;
                    case Direction.EAST -> STANDARD_EAST;
                    default -> STANDARD;
                };
            }
            case MIDDLE: {
                return switch (dir) {
                    case Direction.NORTH -> MIDDLE;
                    case Direction.SOUTH -> MIDDLE_EAST;
                    case Direction.EAST -> MIDDLE_WEST;
                    default -> MIDDLE_SOUTH;
                };
            }
            case OUTER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER_WEST;
                    case Direction.SOUTH -> OUTER_SOUTH;
                    case Direction.EAST -> OUTER_EAST;
                    default -> OUTER;
                };
            }
            case OUTER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER_EAST;
                    case Direction.SOUTH -> OUTER;
                    case Direction.EAST -> OUTER_SOUTH;
                    default -> OUTER_WEST;
                };
            }
            case LEFT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> LEFT_EDGE;
                    case Direction.SOUTH -> LEFT_EDGE_EAST;
                    case Direction.EAST -> LEFT_EDGE_NORTH;
                    default -> LEFT_EDGE_SOUTH;
                };
            }
            case RIGHT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> RIGHT_EDGE;
                    case Direction.SOUTH -> RIGHT_EDGE_EAST;
                    case Direction.EAST -> RIGHT_EDGE_NORTH;
                    default -> RIGHT_EDGE_SOUTH;
                };
            }
            case INNER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER_NORTH;
                    case Direction.SOUTH -> INNER_SOUTH;
                    case Direction.EAST -> INNER_EAST;
                    default -> INNER;
                };
            }
            case INNER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER;
                    case Direction.SOUTH -> INNER_EAST;
                    case Direction.EAST -> INNER_NORTH;
                    default -> INNER_SOUTH;
                };
            }
        }
        return STANDARD;
    }

    public boolean isArmChair(BlockState state) {
        return state.m_60734_().getClass().isAssignableFrom(ArmChairColoredBlock.class) && state.m_60734_() instanceof ArmChairColoredBlock;
    }

    private ArmChairShape getShape(BlockState state, BlockGetter world, BlockPos pos) {
        Direction direction3;
        Comparable direction2;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockState blockState = world.m_8055_(pos.m_121945_(direction));
        boolean right = this.canConnect(world, pos, ((Direction)state.m_61143_((Property)f_54117_)).m_122428_(), (Direction)state.m_61143_((Property)f_54117_));
        boolean left = this.canConnect(world, pos, ((Direction)state.m_61143_((Property)f_54117_)).m_122427_(), (Direction)state.m_61143_((Property)f_54117_));
        if (this.isArmChair(blockState) && ((Direction)(direction2 = blockState.m_61143_((Property)f_54117_))).m_122434_() != ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() && this.isDifferentOrientation(state, world, pos, ((Direction)direction2).m_122424_())) {
            if (direction2 == direction.m_122428_()) {
                return ArmChairShape.OUTER_LEFT;
            }
            return ArmChairShape.OUTER_RIGHT;
        }
        direction2 = world.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (this.isArmChair((BlockState)direction2) && (direction3 = (Direction)((StateHolder)direction2).m_61143_((Property)f_54117_)).m_122434_() != ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() && this.isDifferentOrientation(state, world, pos, direction3)) {
            if (direction3 == direction.m_122428_()) {
                return ArmChairShape.INNER_LEFT;
            }
            return ArmChairShape.INNER_RIGHT;
        }
        if (left && right) {
            return ArmChairShape.MIDDLE;
        }
        if (left) {
            return ArmChairShape.LEFT_EDGE;
        }
        if (right) {
            return ArmChairShape.RIGHT_EDGE;
        }
        return ArmChairShape.STRAIGHT;
    }

    public boolean canConnect(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        return state.m_60734_().getClass().isAssignableFrom(ArmChairColoredBlock.class) && state.m_60734_() instanceof ArmChairColoredBlock;
    }

    private boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.m_8055_(pos.m_121945_(dir));
        return !this.isArmChair(blockState) || blockState.m_61143_((Property)f_54117_) != state.m_61143_((Property)f_54117_);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122479_() ? (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)world, pos))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.m_8125_() : ctx.m_8125_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)this.getShape(blockState, (BlockGetter)ctx.m_43725_(), ctx.m_8083_())))).m_61124_((Property)f_54117_, (Comparable)facing);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.m_49966_().m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.m_6807_(this.m_49966_(), world, pos, oldState, false);
        }
    }
}

