/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config.option;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.config.option.ConfigIO;
import com.unlikepaladin.pfm.config.option.ConfigSizeTracker;
import com.unlikepaladin.pfm.config.option.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConfigOption<T>
implements Comparable<String> {
    public static final byte NULL_TYPE = 0;
    public static final byte BOOL_TYPE = 1;

    public abstract Component getTitle();

    public abstract String getCategory();

    public abstract T getValue();

    public abstract T getDefaultValue();

    public abstract Component getToolTip();

    public abstract void setValue(T var1);

    public abstract Class<T> getType();

    public abstract boolean isDefault();

    public abstract Side getSide();

    public abstract byte getConfigType();

    public static Side getSide(String string) {
        if (Objects.equals(string, Side.CLIENT.m_7912_())) {
            return Side.CLIENT;
        }
        if (Objects.equals(string, Side.SERVER.m_7912_())) {
            return Side.SERVER;
        }
        return null;
    }

    public String toString() {
        return "{Type: " + String.valueOf(this.getType()) + ", Title: " + ((TranslatableContents)this.getTitle().m_214077_()).m_237508_() + ", Category: " + this.getCategory() + ", Value: " + String.valueOf(this.getValue()) + ", Side:" + String.valueOf((Object)this.getSide()) + "}";
    }

    public abstract void write(DataOutput var1) throws IOException;

    public static void writeConfigOption(FriendlyByteBuf packetByteBuf, AbstractConfigOption abstractConfigOption) {
        if (abstractConfigOption == null) {
            packetByteBuf.writeByte(0);
        } else {
            try {
                ConfigIO.write(abstractConfigOption, (DataOutput)new ByteBufOutputStream((ByteBuf)packetByteBuf));
            }
            catch (IOException iOException) {
                throw new EncoderException((Throwable)iOException);
            }
        }
    }

    public static AbstractConfigOption readConfigOption(FriendlyByteBuf packetByteBuf) {
        return AbstractConfigOption.readConfigOption(packetByteBuf, new ConfigSizeTracker(0x200000L));
    }

    public static AbstractConfigOption readConfigOption(FriendlyByteBuf packetByteBuf, ConfigSizeTracker sizeTracker) {
        int i = packetByteBuf.readerIndex();
        byte b0 = packetByteBuf.readByte();
        if (b0 == 0) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Config Option Type was null");
            return null;
        }
        packetByteBuf.readerIndex(i);
        try {
            return ConfigIO.read((DataInput)new ByteBufInputStream((ByteBuf)packetByteBuf), sizeTracker);
        }
        catch (IOException var5) {
            throw new EncoderException((Throwable)var5);
        }
    }

    @Override
    public int compareTo(@NotNull String o) {
        return this.getCategory().compareTo(o);
    }
}

