/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.lootr;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.LootrTags;
import noobanidus.mods.lootr.block.entities.LootrChestBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.integration.lootr.LootrVariantChestBlockEntity;
import org.violetmoon.zeta.item.ZetaBlockItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.IZetaBlockItemProvider;

public class LootrVariantChestBlock
extends VariantChestBlock
implements IZetaBlockItemProvider {
    public LootrVariantChestBlock(String type, ZetaModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties properties) {
        super("lootr", type, module, supplier, properties.m_60978_(2.5f));
    }

    public float m_7325_() {
        if (((Boolean)ConfigManager.BLAST_IMMUNE.get()).booleanValue()) {
            return Float.MAX_VALUE;
        }
        if (((Boolean)ConfigManager.BLAST_RESISTANT.get()).booleanValue()) {
            return 16.0f;
        }
        return super.m_7325_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (player.m_6144_()) {
            ChestUtil.handleLootSneak((Block)this, (Level)world, (BlockPos)pos, (Player)player);
        } else if (!ChestBlock.m_51508_((LevelAccessor)world, (BlockPos)pos)) {
            ChestUtil.handleLootChest((Block)this, (Level)world, (BlockPos)pos, (Player)player);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LootrVariantChestBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)f_51480_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return f_51485_;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_51478_, (Comparable)direction)).m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_51480_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        return null;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        if (((Boolean)ConfigManager.POWER_COMPARATORS.get()).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? LootrChestBlockEntity::lootrLidAnimateTick : null;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof LootrChestBlockEntity) {
            ((LootrChestBlockEntity)blockentity).m_155350_();
        }
    }

    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        return new Item(block, props, false);
    }

    public static class Item
    extends ZetaBlockItem {
        private final boolean trap;

        public Item(Block block, Item.Properties props, boolean trap) {
            super(block, props);
            this.trap = trap;
        }

        public InteractionResult onItemUseFirstZeta(ItemStack stack, UseOnContext context) {
            if (!context.m_7078_()) {
                Player player = context.m_43723_();
                Level level = context.m_43725_();
                BlockPos pos = context.m_8083_();
                Block block = this.m_40614_();
                if (player != null && player.m_7500_()) {
                    TagKey key;
                    BlockState state = level.m_8055_(pos);
                    TagKey tagKey = key = this.trap ? LootrTags.Blocks.TRAPPED_CHESTS : LootrTags.Blocks.CHESTS;
                    if (state.m_204336_(key) && !state.m_60713_(block)) {
                        BlockEntity entity = level.m_7702_(pos);
                        CompoundTag nbt = entity == null ? null : entity.serializeNBT();
                        level.m_7731_(pos, block.m_152465_(state), 18);
                        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                        BlockEntity newEntity = level.m_7702_(pos);
                        if (newEntity != null && nbt != null) {
                            newEntity.m_142466_(nbt);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                }
            }
            return super.onItemUseFirstZeta(stack, context);
        }
    }
}

