/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.ServerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.IServerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.app.CoinMiner;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.ElectricityTicker;
import com.mrcrayfish.furniture.refurbished.electricity.LinkManager;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Bootstrap {
    private static boolean started;

    public static void init() {
        Network.init();
        Bootstrap.registerDispenserBehaviours();
        Bootstrap.registerCauldronBehaviours();
        Bootstrap.registerFrameworkEvents();
        FrameworkAPI.registerSyncedDataKey(Seat.LOCK_YAW);
        Computer computer = Computer.get();
        computer.installProgram(Utils.resource("paddle_ball"), PaddleBall::new);
        computer.installProgram(Utils.resource("home_control"), HomeControl::new);
        computer.installProgram(Utils.resource("marketplace"), Marketplace::new);
        computer.installProgram(Utils.resource("coin_miner"), CoinMiner::new);
        computer.installService(PaddleBall.SERVICE);
    }

    private static void registerFrameworkEvents() {
        TickEvents.START_SERVER.register((IFrameworkEvent)((ITickEvent.StartServer)server -> {
            DeliveryService.get(server).ifPresent(DeliveryService::serverTick);
            Computer.get().getServices().forEach(IService::tick);
        }));
        ServerEvents.STARTED.register((IFrameworkEvent)((IServerEvent.Started)server -> {
            started = true;
        }));
        ServerEvents.STOPPED.register((IFrameworkEvent)((IServerEvent.Stopped)server -> {
            started = false;
        }));
        TickEvents.START_LEVEL.register((IFrameworkEvent)((ITickEvent.StartLevel)level -> {
            if (started) {
                ElectricityTicker.get(level).earlyTick();
            }
        }));
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)player -> {
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerTick(player));
            }
        }));
        PlayerEvents.LOGGED_OUT.register((IFrameworkEvent)((IPlayerEvent.LoggedOut)player -> {
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                DeliveryService.get(server).ifPresent(service -> service.playerLoggedOut(player));
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerLoggedOut(player));
            }
        }));
    }

    private static void registerDispenserBehaviours() {
        DispenserBlock.m_52672_(() -> ModItems.SPATULA.get(), (source, stack) -> {
            FryingPanBlockEntity fryingPan;
            GrillBlockEntity grill;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(direction).m_7495_();
            BlockEntity patt4815$temp = source.m_7727_().m_7702_(pos);
            if (patt4815$temp instanceof GrillBlockEntity && (grill = (GrillBlockEntity)patt4815$temp).flipItems()) {
                FryingPanBlock.playSpatulaScoopSound((Level)source.m_7727_(), pos.m_7494_(), 0.0);
                Network.getPlay().sendToTrackingBlockEntity(() -> grill, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.m_7961_(), direction));
                return stack;
            }
            pos = source.m_7961_().m_121945_(direction);
            BlockEntity patt5377$temp = source.m_7727_().m_7702_(pos);
            if (patt5377$temp instanceof FryingPanBlockEntity && (fryingPan = (FryingPanBlockEntity)patt5377$temp).isFlippingNeeded()) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound((Level)source.m_7727_(), pos, 0.1875);
                Network.getPlay().sendToTrackingBlockEntity(() -> fryingPan, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.m_7961_(), direction));
                return stack;
            }
            return stack;
        });
        DispenserBlock.m_52672_(() -> ModItems.KNIFE.get(), (source, stack) -> {
            CuttingBoardBlockEntity cuttingBoard;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(direction);
            BlockEntity patt6247$temp = source.m_7727_().m_7702_(pos);
            if (patt6247$temp instanceof CuttingBoardBlockEntity && (cuttingBoard = (CuttingBoardBlockEntity)patt6247$temp).sliceItem((Level)source.m_7727_(), false)) {
                if (stack.m_220157_(1, source.m_7727_().f_46441_, null)) {
                    stack.m_41764_(0);
                }
                Network.getPlay().sendToTrackingBlockEntity(() -> cuttingBoard, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.KNIFE, source.m_7961_(), direction));
            }
            return stack;
        });
        DispenserBlock.m_52672_(() -> ModItems.PACKAGE.get(), (source, stack) -> {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Vec3 pos = source.m_7961_().m_121945_(direction).m_252807_();
            PackageItem.getPackagedItems(stack).forEach(s -> Containers.m_18992_((Level)source.m_7727_(), (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)s));
            return ItemStack.f_41583_;
        });
    }

    private static void registerCauldronBehaviours() {
        CauldronInteraction.f_175607_.put(((DoorMatBlock)ModBlocks.DOOR_MAT.get()).m_5456_(), (state, level, pos, player, hand, stack) -> {
            CompoundTag tag;
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (block == ModBlocks.DOOR_MAT.get() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null) {
                if (!level.m_5776_()) {
                    ItemStack copy = stack.m_255036_(1);
                    BlockItem.m_186338_((ItemStack)copy, (BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_MAT.get()), (CompoundTag)new CompoundTag());
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, copy);
                    } else if (player.m_36356_(copy)) {
                        player.f_36095_.m_150429_();
                    } else {
                        player.m_36176_(copy, false);
                    }
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.PASS;
        });
    }
}

