/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.ProcessingContainerBlockEntity;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IModuleNode;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class ElectricityModuleProcessingLootBlockEntity
extends ProcessingContainerBlockEntity
implements IModuleNode {
    protected final Set<Connection> connections = new HashSet<Connection>();
    protected final Set<BlockPos> powerSources = new HashSet<BlockPos>();
    protected boolean powered;
    protected boolean receivingPower;

    protected ElectricityModuleProcessingLootBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, containerSize, recipeType);
    }

    @Override
    public boolean canProcess() {
        return this.powered && super.canProcess();
    }

    @Override
    public Level getNodeLevel() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getNodePosition() {
        return this.f_58858_;
    }

    @Override
    public BlockEntity getNodeOwner() {
        return this;
    }

    @Override
    public boolean isSourceNode() {
        return false;
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            this.syncDataToTrackingClients();
        }
    }

    @Override
    public Set<Connection> getNodeConnections() {
        return this.connections;
    }

    @Override
    public void setNodeReceivingPower(boolean state) {
        this.receivingPower = state;
    }

    @Override
    public boolean isNodeReceivingPower() {
        return this.receivingPower;
    }

    @Override
    public Set<BlockPos> getPowerSources() {
        return this.powerSources;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNodeNbt(tag);
        if (tag.m_128425_("Powered", 1)) {
            this.powered = tag.m_128471_("Powered");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeNodeNbt(tag);
        tag.m_128379_("Powered", this.powered);
    }

    @Override
    public void syncDataToTrackingClients() {
        this.updateNodeConnections();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNodeNbt(tag);
        tag.m_128379_("Powered", this.powered);
        return tag;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public int hashCode() {
        return this.f_58858_.hashCode();
    }

    public void m_187476_(ItemStack stack) {
        this.saveNodeNbtToItem(stack);
    }
}

