/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MarketplaceGraphics
extends DisplayableProgram<Marketplace> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/program/marketplace.png");
    private final Scene catalogueScene = new CatalogueScene(this);
    private final Scene shoppingCartScene = new ShoppingCartScene(this);
    private final Scene mailboxScene = new MailboxScene(this);

    public MarketplaceGraphics(Marketplace program) {
        super(program, 112, 54);
        this.setScene(new ComingSoon(this));
    }

    public static class CatalogueScene
    extends Scene {
        private final MarketplaceGraphics program;
        private final ComputerSelectionList<Item> itemList;

        private CatalogueScene(MarketplaceGraphics program) {
            this.program = program;
            this.itemList = this.addWidget(new ComputerSelectionList(program.getWidth() - 10, program.getHeight() - 26, 0, 100, 30));
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.itemList.setPosition(contentStart + 5, contentTop + 21);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.m_280509_(0, 0, this.program.getWidth(), 16, -10143432);
            graphics.m_280218_(TEXTURE, 5, 2, 0, 0, 12, 12);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, Integer.toString(this.getEmeraldCount()), 50, 5, -1);
        }

        private int getEmeraldCount() {
            return Optional.ofNullable(((Marketplace)this.program.getProgram()).getComputer().getMenu()).map(menu -> (int)menu.getProgramData()).orElse(0);
        }

        private static class Item
        extends ObjectSelectionList.Entry<Item> {
            private final ComputerButton buyButton = new ComputerButton(50, 16, (Component)Component.m_237113_((String)"Buy"), btn -> System.out.println("Hello"));

            public Component m_142172_() {
                return CommonComponents.f_237098_;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
                graphics.m_280509_(left, top, left + rowWidth, top + rowHeight, -1);
                this.buyButton.m_264152_(left + rowWidth - this.buyButton.m_5711_(), top);
                this.buyButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                this.buyButton.m_6375_(mouseX, mouseY, button);
                return true;
            }
        }
    }

    public static class ShoppingCartScene
    extends Scene {
        private ShoppingCartScene(MarketplaceGraphics program) {
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }
    }

    public static class MailboxScene
    extends Scene {
        private MailboxScene(MarketplaceGraphics program) {
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }
    }

    public static class ComingSoon
    extends Scene {
        private final MarketplaceGraphics program;

        public ComingSoon(MarketplaceGraphics program) {
            this.program = program;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            Icon icon = Display.get().getIcon(((Marketplace)this.program.getProgram()).getId());
            if (icon != null) {
                graphics.m_280163_(icon.texture(), (this.program.getWidth() - 16) / 2, 10, (float)icon.u(), (float)icon.v(), 16, 16, 128, 128);
            }
            graphics.m_280137_(Minecraft.m_91087_().f_91062_, "Coming Soon!", 56, 35, -1);
        }
    }
}

