/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdateMailboxes;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class DeliveryService
extends SavedData {
    private static final String STORAGE_ID = "refurbished_furniture_delivery_service";
    private final MinecraftServer server;
    private final Map<Pair<ResourceLocation, BlockPos>, Mailbox> locator = new HashMap<Pair<ResourceLocation, BlockPos>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<ResourceLocation, BlockPos>> pendingNames = new HashMap<UUID, Pair<ResourceLocation, BlockPos>>();
    private final Set<UUID> playerRequests = new HashSet<UUID>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        if (level != null) {
            return Optional.of((DeliveryService)level.m_8895_().m_164861_(tag -> new DeliveryService(server, (CompoundTag)tag), () -> new DeliveryService(server), STORAGE_ID));
        }
        return Optional.empty();
    }

    public DeliveryService(MinecraftServer server) {
        this(server, new CompoundTag());
    }

    public DeliveryService(MinecraftServer server, CompoundTag compound) {
        this.server = server;
        this.load(compound);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel();
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().m_135782_(), (Object)mailbox2.pos()));
            this.m_77762_();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick());
    }

    public void playerLoggedOut(Player player) {
        this.playerRequests.remove(player.m_20148_());
    }

    public boolean sendMail(UUID id, ItemStack stack) {
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox != null && mailbox.queue().size() < (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            mailbox.queue().offer(stack);
            this.m_77762_();
            return true;
        }
        return false;
    }

    void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public boolean canCreateMailbox(Player player) {
        long count = this.mailboxes.values().stream().filter(box -> player.m_20148_().equals(box.owner().getValue())).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    public Mailbox getOrCreateMailBox(MailboxBlockEntity blockEntity) {
        this.duplicateIdCheck(blockEntity);
        return this.mailboxes.computeIfAbsent(blockEntity.getId(), uuid -> {
            ResourceKey levelKey = blockEntity.m_58904_().m_46472_();
            BlockPos pos = blockEntity.m_58899_();
            Mailbox mailbox = new Mailbox((UUID)uuid, (ResourceKey<Level>)levelKey, pos, (MutableObject<UUID>)new MutableObject(), (MutableObject<String>)new MutableObject((Object)""), (Queue<ItemStack>)new ArrayDeque<ItemStack>(), new MutableBoolean(), this);
            this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.m_135782_(), (Object)pos), mailbox);
            this.m_77762_();
            return mailbox;
        });
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.m_58899_())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(Level level, BlockPos pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.m_46472_().m_135782_(), (Object)pos)));
    }

    public void markMailboxAsPendingName(Player player, Level level, BlockPos pos) {
        this.pendingNames.put(player.m_20148_(), (Pair<ResourceLocation, BlockPos>)Pair.of((Object)level.m_46472_().m_135782_(), (Object)pos));
    }

    public boolean renameMailbox(Player player, Level level, BlockPos pos, String customName) {
        Pair<ResourceLocation, BlockPos> pendingLocation = this.pendingNames.remove(player.m_20148_());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().getValue(), player.m_20148_())) {
                return false;
            }
            Pair location = Pair.of((Object)level.m_46472_().m_135782_(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public void sendMailboxesToPlayer(ServerPlayer player) {
        if (!this.playerRequests.contains(player.m_20148_())) {
            Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUpdateMailboxes(this.mailboxes.values()));
            this.playerRequests.add(player.m_20148_());
        }
    }

    public void m_77762_() {
        super.m_77762_();
        this.playerRequests.clear();
    }

    private void load(CompoundTag compound) {
        if (compound.m_128425_("Mailboxes", 9)) {
            ListTag list = compound.m_128437_("Mailboxes", 10);
            list.forEach(tag -> {
                try {
                    CompoundTag mailboxTag = (CompoundTag)tag;
                    ResourceKey<Level> levelKey = DeliveryService.createLevelKey(mailboxTag.m_128461_("Level"));
                    if (levelKey == null) {
                        Constants.LOG.error("Failed to load a mailbox due to invalid dimension");
                        return;
                    }
                    UUID id = mailboxTag.m_128342_("UUID");
                    BlockPos pos = BlockPos.m_122022_((long)mailboxTag.m_128454_("BlockPosition"));
                    MutableObject owner = new MutableObject();
                    if (mailboxTag.m_128425_("Owner", 11)) {
                        owner.setValue((Object)mailboxTag.m_128342_("Owner"));
                    }
                    String customName = mailboxTag.m_128461_("CustomName");
                    customName = customName.substring(0, Math.min(customName.length(), 32));
                    Queue<ItemStack> queue = Mailbox.readQueueListTag(mailboxTag);
                    Mailbox mailbox = new Mailbox(id, levelKey, pos, (MutableObject<UUID>)owner, (MutableObject<String>)new MutableObject((Object)customName), queue, new MutableBoolean(), this);
                    this.mailboxes.putIfAbsent(id, mailbox);
                    this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.m_135782_(), (Object)pos), mailbox);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load a mailbox due to invalid data");
                }
            });
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        this.mailboxes.forEach((uuid, mailbox) -> {
            if (!mailbox.removed().booleanValue()) {
                CompoundTag mailboxTag = new CompoundTag();
                mailboxTag.m_128362_("UUID", uuid);
                mailboxTag.m_128359_("Level", mailbox.levelKey().m_135782_().toString());
                mailboxTag.m_128356_("BlockPosition", mailbox.pos().m_121878_());
                Optional.ofNullable((UUID)mailbox.owner().getValue()).ifPresent(id -> mailboxTag.m_128362_("Owner", id));
                Optional.ofNullable((String)mailbox.customName().getValue()).ifPresent(name -> mailboxTag.m_128359_("CustomName", name));
                mailbox.writeQueue(mailboxTag);
                list.add((Object)mailboxTag);
            }
        });
        compound.m_128365_("Mailboxes", (Tag)list);
        return compound;
    }

    @Nullable
    private static ResourceKey<Level> createLevelKey(String levelKey) {
        ResourceKey resourceKey;
        if (levelKey.isBlank()) {
            resourceKey = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    resourceKey = Level.f_46428_;
                    break;
                }
                case "minecraft:the_nether": {
                    resourceKey = Level.f_46429_;
                    break;
                }
                case "minecraft:the_end": {
                    resourceKey = Level.f_46430_;
                    break;
                }
                default: {
                    resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(levelKey));
                }
            }
        }
        return resourceKey;
    }

    public static boolean isBannedItem(ItemStack stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.m_41720_().m_142095_()) {
            return true;
        }
        String name = stack.m_41720_().m_5524_();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }
}

