/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public abstract class UpgradeContainerBase<W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>>
implements IServerUpdater {
    protected final ArrayList<Slot> slots = new ArrayList();
    private final int upgradeContainerId;
    protected W upgradeWrapper;
    protected final Player player;
    private final UpgradeContainerType<W, C> type;
    private boolean isOpen = false;

    protected UpgradeContainerBase(Player player, int upgradeContainerId, W upgradeWrapper, UpgradeContainerType<W, C> type) {
        this.upgradeContainerId = upgradeContainerId;
        this.upgradeWrapper = upgradeWrapper;
        this.player = player;
        this.type = type;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public UpgradeContainerType<W, C> getType() {
        return this.type;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void sendBooleanToServer(String key, boolean value) {
        if (!this.player.m_9236_().f_46443_) {
            return;
        }
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), key, value));
    }

    @Override
    public void sendDataToServer(Supplier<CompoundTag> supplyData) {
        if (!this.player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag data = supplyData.get();
        data.m_128405_("containerId", this.upgradeContainerId);
        PacketHandler.INSTANCE.sendToServer(new SyncContainerClientDataMessage(data));
    }

    public void onInit() {
    }

    public abstract void handleMessage(CompoundTag var1);

    public ItemStack getUpgradeStack() {
        return this.upgradeWrapper.getUpgradeStack();
    }

    public W getUpgradeWrapper() {
        return this.upgradeWrapper;
    }

    public void setUpgradeWrapper(IUpgradeWrapper updatedUpgradeWrapper) {
        this.upgradeWrapper = updatedUpgradeWrapper;
    }

    public boolean containsSlot(Slot slot) {
        for (Slot containerSlot : this.slots) {
            if (containerSlot != slot) continue;
            return true;
        }
        return false;
    }

    public ItemStack getSlotStackToTransfer(Slot slot) {
        return slot.m_7993_();
    }

    public void onTakeFromSlot(Slot slot, Player player, ItemStack slotStack) {
        slot.m_142406_(player, slotStack);
    }

    public boolean mergeIntoStorageFirst(Slot slot) {
        return true;
    }

    public boolean allowsPickupAll(Slot slot) {
        return true;
    }

    public int getUpgradeContainerId() {
        return this.upgradeContainerId;
    }
}

