/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher.SentryWatcherModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.SentryWatcherEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class SentryWatcherRenderer<M extends EntityModel<SentryWatcherEntity>>
extends EntityRenderer<SentryWatcherEntity>
implements RenderLayerParent<SentryWatcherEntity, M> {
    private static final ResourceLocation SKIN = new ResourceLocation("the_bumblezone", "textures/entity/sentry_watcher.png");
    protected final SentryWatcherModel model;
    protected final List<RenderLayer<SentryWatcherEntity, M>> layers = Lists.newArrayList();

    public SentryWatcherRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SentryWatcherModel(context.m_174023_(SentryWatcherModel.LAYER_LOCATION));
        this.addLayer(new EyeLayerRenderer(this));
    }

    protected final boolean addLayer(RenderLayer<SentryWatcherEntity, M> renderLayer) {
        return this.layers.add(renderLayer);
    }

    public M m_7200_() {
        return (M)((Object)this.model);
    }

    public void render(SentryWatcherEntity sentryWatcherEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        float rotationLerp = Mth.m_14179_((float)g, (float)sentryWatcherEntity.f_19860_, (float)sentryWatcherEntity.m_146909_());
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_85837_(0.0, sentryWatcherEntity.m_20191_().m_82376_() + (double)0.05f, 0.0);
        float shakeEffect = 0.0f;
        if (sentryWatcherEntity.hasShaking()) {
            shakeEffect += (float)(Math.cos((double)sentryWatcherEntity.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        poseStack.m_252781_(Axis.f_252392_.m_252977_(sentryWatcherEntity.m_146908_() + shakeEffect));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f - sentryWatcherEntity.m_146909_()));
        this.model.m_6839_(sentryWatcherEntity, 0.0f, 0.0f, g);
        this.model.m_6973_(sentryWatcherEntity, 0.0f, 0.0f, 0.0f, 0.0f, rotationLerp);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean glowing = minecraft.m_91314_((Entity)sentryWatcherEntity);
        RenderType renderType = this.getRenderType(sentryWatcherEntity, true, false, glowing);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
            this.model.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!sentryWatcherEntity.m_5833_()) {
            for (RenderLayer<SentryWatcherEntity, M> renderLayer : this.layers) {
                renderLayer.m_6494_(poseStack, multiBufferSource, i, (Entity)sentryWatcherEntity, 0.0f, 0.0f, g, 0.0f, 0.0f, rotationLerp);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)sentryWatcherEntity, f, g, poseStack, multiBufferSource, i);
    }

    @Nullable
    protected RenderType getRenderType(SentryWatcherEntity sentryWatcherEntity, boolean bodyVisible, boolean hidden, boolean glowing) {
        ResourceLocation resourceLocation = this.getTextureLocation(sentryWatcherEntity);
        if (bodyVisible) {
            return this.model.m_103119_(resourceLocation);
        }
        if (glowing) {
            return RenderType.m_110491_((ResourceLocation)resourceLocation);
        }
        return null;
    }

    public ResourceLocation getTextureLocation(SentryWatcherEntity sentryWatcherEntity) {
        return SKIN;
    }

    static class EyeLayerRenderer<T extends Entity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation EYES = new ResourceLocation("the_bumblezone", "textures/entity/sentry_watcher_eyes.png");
        private static final RenderType RENDER_TYPE_EYES = RenderType.m_110488_((ResourceLocation)EYES);
        protected SentryWatcherModel model;

        public EyeLayerRenderer(RenderLayerParent<T, M> renderLayerParent) {
            super(renderLayerParent);
        }

        public void m_6494_(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T entity, float f, float g, float h, float j, float k, float l) {
            SentryWatcherEntity sentryWatcherEntity;
            if (entity instanceof SentryWatcherEntity && (sentryWatcherEntity = (SentryWatcherEntity)((Object)entity)).hasActivated()) {
                VertexConsumer vertexConsumer = multiBufferSource.m_6299_(this.renderType());
                this.m_117386_().m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public RenderType renderType() {
            return RENDER_TYPE_EYES;
        }
    }
}

