/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.living;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlockWhite;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CosmicCrystalEntity
extends LivingEntity {
    public static final EntityDataSerializer<CosmicCrystalState> COSMIC_CRYSTAL_STATE_SERIALIZER = EntityDataSerializer.m_238090_(CosmicCrystalState.class);
    private static final EntityDataAccessor<CosmicCrystalState> COSMIC_CRYSTAL_STATE = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, COSMIC_CRYSTAL_STATE_SERIALIZER);
    private static final EntityDataAccessor<Integer> INITIAL_ROTATION_ANIMATION_TIMESPAN = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE_TIMESPAN = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LASER_START_DELAY = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LASER_FIRE_START_TIME = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SYNCED_CURRENT_STATE_TIME_TICK = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ORBIT_OFFSET_DEGREES = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DIFFICULTY_BOOST = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> COLLIDED = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SECOND_PHASE = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> ESSENCE_CONTROLLER_UUID = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<BlockPos>> ESSENCE_CONTROLLER_BLOCK_POS = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<String> ESSENCE_CONTROLLER_DIMENSION = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SHIELD = SynchedEntityData.m_135353_(CosmicCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Vec3 UP_VECT = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 POSITIVE_X_VECT = new Vec3(1.0, 0.0, 0.0);
    public static final int MAX_RANGE = 30;
    protected static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(30.0).m_26888_(livingEntity -> !(livingEntity instanceof CosmicCrystalEntity) && livingEntity.m_5789_());
    public final AnimationState idleAnimationState = new AnimationState();
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
    private UUID targetEntityUUID = null;
    private Entity targetEntity = null;
    private Vec3 prevTargetPosition = new Vec3(0.0, 0.0, 0.0);
    public int currentStateTimeTick = 0;
    public int currentTickCount = 0;
    public int animationTimeTick = 0;
    public int prevAnimationTick = 0;
    public Vec3 prevLookAngle = new Vec3(1.0, 0.0, 0.0);
    private boolean laserChargeSoundPlayed = false;
    public int lastPhysicalHit = 0;
    public final ArrayDeque<CosmicCrystalState> pastStates = new ArrayDeque();
    private boolean noAI = false;

    public CosmicCrystalEntity(EntityType<? extends CosmicCrystalEntity> entityType, Level level) {
        super(entityType, level);
        this.idleAnimationState.m_216977_(this.f_19797_);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)BzGeneralConfigs.cosmicCrystalHealth).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 30.0);
    }

    public UUID getEssenceController() {
        return ((Optional)this.f_19804_.m_135370_(ESSENCE_CONTROLLER_UUID)).orElse(null);
    }

    public void setEssenceController(UUID essenceController) {
        this.f_19804_.m_135381_(ESSENCE_CONTROLLER_UUID, Optional.of(essenceController));
    }

    public BlockPos getEssenceControllerBlockPos() {
        return ((Optional)this.f_19804_.m_135370_(ESSENCE_CONTROLLER_BLOCK_POS)).orElse(null);
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.f_19804_.m_135381_(ESSENCE_CONTROLLER_BLOCK_POS, essenceControllerBlockPos == null ? Optional.empty() : Optional.of(essenceControllerBlockPos));
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        String dimensionString = (String)this.f_19804_.m_135370_(ESSENCE_CONTROLLER_DIMENSION);
        if (dimensionString == null || dimensionString.isEmpty()) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionString));
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.f_19804_.m_135381_(ESSENCE_CONTROLLER_DIMENSION, (Object)essenceControllerDimension.m_135782_().toString());
    }

    public int getOrbitOffsetDegrees() {
        return (Integer)this.f_19804_.m_135370_(ORBIT_OFFSET_DEGREES);
    }

    public void setOrbitOffsetDegrees(int orbitOffsetDegrees) {
        this.f_19804_.m_135381_(ORBIT_OFFSET_DEGREES, (Object)orbitOffsetDegrees);
    }

    public float getDifficultyBoost() {
        return ((Float)this.f_19804_.m_135370_(DIFFICULTY_BOOST)).floatValue();
    }

    public void setDifficultyBoost(float difficultyBoost) {
        this.f_19804_.m_135381_(DIFFICULTY_BOOST, (Object)Float.valueOf(difficultyBoost));
    }

    public void setCosmicCrystalState(CosmicCrystalState cosmicCrystalState) {
        if (!this.m_9236_().m_5776_() && cosmicCrystalState != this.getCosmicCrystalState()) {
            if (this.f_19797_ > 1) {
                this.currentStateTimeTick = 0;
                this.lastPhysicalHit = 0;
                this.setSecondPhase(false);
            }
            if (this.targetEntity != null) {
                this.prevTargetPosition = this.targetEntity.m_20182_();
            }
            this.pastStates.addFirst(this.getCosmicCrystalState());
            if (this.pastStates.size() > 8) {
                this.pastStates.removeLast();
            }
            this.f_19804_.m_135381_(COSMIC_CRYSTAL_STATE, (Object)cosmicCrystalState);
            switch (this.getCosmicCrystalState()) {
                case NORMAL: {
                    this.setInitialRotationAnimationTimespan(40);
                    this.setStateTimespan(Integer.MAX_VALUE);
                    break;
                }
                case TRACKING_SMASHING_ATTACK: {
                    this.setInitialRotationAnimationTimespan((int)(100.0f - 40.0f * this.getDifficultyBoost() + (float)(this.getOrbitOffsetDegrees() / 3)));
                    this.setStateTimespan(450);
                    this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_CRASH_CHARGE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case TRACKING_SPINNING_ATTACK: {
                    int timeOffset = (int)((float)this.getOrbitOffsetDegrees() * this.getDifficultyBoost() * this.getDifficultyBoost());
                    this.setInitialRotationAnimationTimespan(20 + timeOffset);
                    this.setStateTimespan((int)((float)timeOffset + this.getDifficultyBoost() * this.getDifficultyBoost() * 80.0f));
                    break;
                }
                case VERTICAL_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(20);
                    this.setLaserFireStartTime(60);
                    this.setStateTimespan(400);
                    break;
                }
                case HORIZONTAL_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(40);
                    this.setLaserFireStartTime(80);
                    this.setStateTimespan(350);
                    break;
                }
                case SWEEP_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(60);
                    this.setLaserFireStartTime(80);
                    this.setStateTimespan(400);
                    break;
                }
                case TRACKING_LASER: {
                    int timeOffset = this.getOrbitOffsetDegrees() / 3;
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay((int)(40.0f + 20.0f * this.getDifficultyBoost() + (float)timeOffset));
                    this.setLaserFireStartTime(80 + timeOffset);
                    this.setStateTimespan(180 + timeOffset);
                }
            }
        }
    }

    public CosmicCrystalState getCosmicCrystalState() {
        return (CosmicCrystalState)((Object)this.f_19804_.m_135370_(COSMIC_CRYSTAL_STATE));
    }

    public void setInitialRotationAnimationTimespan(int initialRotationAnimationTimespan) {
        this.animationTimeTick = 0;
        this.prevAnimationTick = 0;
        this.f_19804_.m_135381_(INITIAL_ROTATION_ANIMATION_TIMESPAN, (Object)initialRotationAnimationTimespan);
        this.setCollided(false);
    }

    public int getInitialRotationAnimationTimespan() {
        return (Integer)this.f_19804_.m_135370_(INITIAL_ROTATION_ANIMATION_TIMESPAN);
    }

    public void setStateTimespan(int stateTimespan) {
        this.f_19804_.m_135381_(STATE_TIMESPAN, (Object)stateTimespan);
    }

    public int getStateTimespan() {
        return (Integer)this.f_19804_.m_135370_(STATE_TIMESPAN);
    }

    public void setLaserStartDelay(int laserStartDelay) {
        this.laserChargeSoundPlayed = false;
        this.f_19804_.m_135381_(LASER_START_DELAY, (Object)laserStartDelay);
    }

    public int getLaserStartDelay() {
        return (Integer)this.f_19804_.m_135370_(LASER_START_DELAY);
    }

    public void setLaserFireStartTime(int laserFireStartTime) {
        this.f_19804_.m_135381_(LASER_FIRE_START_TIME, (Object)laserFireStartTime);
    }

    public int getLaserFireStartTime() {
        return (Integer)this.f_19804_.m_135370_(LASER_FIRE_START_TIME);
    }

    public void setSyncedCurrentStateTimeTick(int syncedCurrentStateTimeTick) {
        this.f_19804_.m_135381_(SYNCED_CURRENT_STATE_TIME_TICK, (Object)syncedCurrentStateTimeTick);
    }

    public int getSyncedCurrentStateTimeTick() {
        return (Integer)this.f_19804_.m_135370_(SYNCED_CURRENT_STATE_TIME_TICK);
    }

    public void setCollided(boolean collided) {
        this.f_19804_.m_135381_(COLLIDED, (Object)collided);
    }

    public boolean getCollided() {
        return (Boolean)this.f_19804_.m_135370_(COLLIDED);
    }

    public void setSecondPhase(boolean smashingPhase) {
        this.f_19804_.m_135381_(SECOND_PHASE, (Object)smashingPhase);
    }

    public boolean getSecondPhase() {
        return (Boolean)this.f_19804_.m_135370_(SECOND_PHASE);
    }

    public void setTargetEntityUUID(UUID targetEntityUUID) {
        this.targetEntityUUID = targetEntityUUID;
    }

    public UUID getTargetEntityUUID() {
        return this.targetEntityUUID;
    }

    public void setShield(boolean shield) {
        this.f_19804_.m_135381_(SHIELD, (Object)shield);
    }

    public boolean getShield() {
        return (Boolean)this.f_19804_.m_135370_(SHIELD);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COSMIC_CRYSTAL_STATE, (Object)CosmicCrystalState.NORMAL);
        this.f_19804_.m_135372_(INITIAL_ROTATION_ANIMATION_TIMESPAN, (Object)0);
        this.f_19804_.m_135372_(STATE_TIMESPAN, (Object)0);
        this.f_19804_.m_135372_(LASER_START_DELAY, (Object)0);
        this.f_19804_.m_135372_(LASER_FIRE_START_TIME, (Object)0);
        this.f_19804_.m_135372_(SYNCED_CURRENT_STATE_TIME_TICK, (Object)0);
        this.f_19804_.m_135372_(ORBIT_OFFSET_DEGREES, (Object)0);
        this.f_19804_.m_135372_(DIFFICULTY_BOOST, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLLIDED, (Object)false);
        this.f_19804_.m_135372_(SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(ESSENCE_CONTROLLER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ESSENCE_CONTROLLER_BLOCK_POS, Optional.empty());
        this.f_19804_.m_135372_(ESSENCE_CONTROLLER_DIMENSION, (Object)"");
        this.f_19804_.m_135372_(SHIELD, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (COSMIC_CRYSTAL_STATE.equals(entityDataAccessor) && this.f_19797_ > 1) {
            this.animationTimeTick = 0;
            this.prevAnimationTick = 0;
            this.currentStateTimeTick = 0;
            this.lastPhysicalHit = 0;
            if (this.targetEntity != null) {
                this.prevTargetPosition = this.targetEntity.m_20182_();
            }
        } else if (SYNCED_CURRENT_STATE_TIME_TICK.equals(entityDataAccessor)) {
            this.currentStateTimeTick = this.getSyncedCurrentStateTimeTick();
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("essenceController")) {
            this.setEssenceController(compoundTag.m_128342_("essenceController"));
        }
        if (compoundTag.m_128441_("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("essenceControllerBlockPos")));
        }
        if (compoundTag.m_128441_("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compoundTag.m_128461_("essenceControllerDimension"))));
        }
        if (compoundTag.m_128441_("prevCosmicCrystalState")) {
            this.setCosmicCrystalState(CosmicCrystalState.valueOf(compoundTag.m_128461_("prevCosmicCrystalState")));
        }
        if (compoundTag.m_128441_("cosmicCrystalState")) {
            this.setCosmicCrystalState(CosmicCrystalState.valueOf(compoundTag.m_128461_("cosmicCrystalState")));
        }
        this.setInitialRotationAnimationTimespan(compoundTag.m_128451_("initialRotationAnimationTimespan"));
        this.setStateTimespan(compoundTag.m_128451_("stateTimespan"));
        this.setLaserStartDelay(compoundTag.m_128451_("laserStartDelay"));
        this.setLaserFireStartTime(compoundTag.m_128451_("laserFireStartTime"));
        this.setSecondPhase(compoundTag.m_128471_("secondPhase"));
        this.setCollided(compoundTag.m_128471_("collided"));
        this.setOrbitOffsetDegrees(compoundTag.m_128451_("orbitOffsetDegrees"));
        if (compoundTag.m_128441_("difficultyBoost")) {
            this.setDifficultyBoost(compoundTag.m_128457_("difficultyBoost"));
        }
        this.currentStateTimeTick = compoundTag.m_128451_("currentStateTimeTick");
        this.setSyncedCurrentStateTimeTick(this.currentStateTimeTick);
        this.animationTimeTick = compoundTag.m_128451_("animationTimeTick");
        this.prevAnimationTick = compoundTag.m_128451_("prevAnimationTick");
        if (compoundTag.m_128441_("targetEntityUUID")) {
            this.targetEntityUUID = compoundTag.m_128342_("targetEntityUUID");
        }
        if (compoundTag.m_128441_("prevLookAngle")) {
            CompoundTag vectTag = compoundTag.m_128469_("prevLookAngle");
            this.prevLookAngle = new Vec3(vectTag.m_128459_("x"), vectTag.m_128459_("y"), vectTag.m_128459_("z"));
        }
        this.noAI = compoundTag.m_128471_("NoAI") || compoundTag.m_128471_("noAI") || compoundTag.m_128471_("noAi");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getEssenceController() != null) {
            compoundTag.m_128362_("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.m_128365_("essenceControllerBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.m_128359_("essenceControllerDimension", this.getEssenceControllerDimension().m_135782_().toString());
        }
        compoundTag.m_128359_("cosmicCrystalState", this.getCosmicCrystalState().name());
        compoundTag.m_128405_("initialRotationAnimationTimespan", this.getInitialRotationAnimationTimespan());
        compoundTag.m_128405_("stateTimespan", this.getStateTimespan());
        compoundTag.m_128405_("laserStartDelay", this.getLaserStartDelay());
        compoundTag.m_128405_("laserFireStartTime", this.getLaserFireStartTime());
        compoundTag.m_128379_("secondPhase", this.getSecondPhase());
        compoundTag.m_128379_("collided", this.getCollided());
        compoundTag.m_128405_("orbitOffsetDegrees", this.getOrbitOffsetDegrees());
        compoundTag.m_128350_("difficultyBoost", this.getDifficultyBoost());
        compoundTag.m_128405_("currentStateTimeTick", this.currentStateTimeTick);
        compoundTag.m_128405_("animationTimeTick", this.animationTimeTick);
        compoundTag.m_128405_("prevAnimationTick", this.prevAnimationTick);
        if (this.targetEntityUUID != null) {
            compoundTag.m_128362_("targetEntityUUID", this.targetEntityUUID);
        }
        CompoundTag vectTag = new CompoundTag();
        vectTag.m_128347_("x", this.prevLookAngle.m_7096_());
        vectTag.m_128347_("y", this.prevLookAngle.m_7098_());
        vectTag.m_128347_("z", this.prevLookAngle.m_7094_());
        compoundTag.m_128365_("prevLookAngle", (Tag)vectTag);
        if (compoundTag.m_128441_("noAi")) {
            compoundTag.m_128379_("noAi", this.noAI);
        } else if (compoundTag.m_128441_("noAI")) {
            compoundTag.m_128379_("noAI", this.noAI);
        } else {
            compoundTag.m_128379_("NoAI", this.noAI);
        }
    }

    public static boolean isOrFromHorizontalState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_SPINNING_ATTACK;
    }

    public static boolean isLaserState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.VERTICAL_LASER || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER;
    }

    public static boolean isTrackingState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_SMASHING_ATTACK || cosmicCrystalState == CosmicCrystalState.TRACKING_SPINNING_ATTACK || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER;
    }

    public static boolean isOrbitState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.NORMAL || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.VERTICAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER;
    }

    public boolean isLaserFiring() {
        boolean isLaserState = CosmicCrystalEntity.isLaserState(this.getCosmicCrystalState());
        return isLaserState && this.currentStateTimeTick > this.getLaserFireStartTime();
    }

    public void m_8119_() {
        if (this.f_19797_ == 1) {
            if (this.m_9236_().m_5776_()) {
                this.spawnLargeParticleCloud(3);
            }
            this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_SPAWN_EXPLOSION.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.m_21224_() && this.m_9236_().m_183599_((Entity)this)) {
            this.m_6153_();
        }
        if (this.noAI) {
            return;
        }
        if (!this.m_9236_().m_5776_() && !this.checkIfStillInEvent()) {
            return;
        }
        if (this.getCosmicCrystalState() == CosmicCrystalState.NORMAL) {
            this.setTargetEntityUUID(null);
            this.targetEntity = null;
            if (this.getEssenceController() == null && this.currentStateTimeTick > 50) {
                CosmicCrystalState chosenAttack;
                while (this.pastStates.contains((Object)(chosenAttack = CosmicCrystalState.values()[this.m_217043_().m_188503_(CosmicCrystalState.values().length)])) || chosenAttack == CosmicCrystalState.NORMAL) {
                }
                this.setCosmicCrystalState(chosenAttack);
            }
        } else if (!this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
            this.setSyncedCurrentStateTimeTick(this.currentStateTimeTick);
        }
        this.prevLookAngle = this.m_20154_();
        this.orbitMovement();
        this.spinningTrackingBehaviour();
        super.m_8119_();
        this.incrementAnimationAndRotationTicks();
        this.spawnFancyParticlesOnClient();
        this.laserBreakBlocks();
        this.smashingBehaviour();
        this.destroyTouchingBlocks();
        ++this.currentStateTimeTick;
        ++this.currentTickCount;
    }

    private boolean checkIfStillInEvent() {
        BlockPos essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null) {
            return false;
        }
        if (this.f_19797_ % 20 != 0 && this.m_20183_().m_123333_((Vec3i)essenceBlockPos) < 16) {
            return true;
        }
        UUID essenceUuid = this.getEssenceController();
        ResourceKey<Level> essenceDimension = this.getEssenceControllerDimension();
        if (essenceUuid == null || essenceDimension == null) {
            return false;
        }
        BlockPos blockPos = this.m_20183_();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.m_9236_(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.m_123341_() - essenceBlockPos.m_123341_()) > arenaSize.m_123341_() / 2 || Math.abs(blockPos.m_123342_() - essenceBlockPos.m_123342_()) > arenaSize.m_123342_() / 2 || Math.abs(blockPos.m_123343_() - essenceBlockPos.m_123343_()) > arenaSize.m_123343_() / 2) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return false;
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return false;
        }
        return true;
    }

    private void orbitMovement() {
        if (this.getEssenceControllerBlockPos() != null) {
            Vec3 orbitPosition;
            if (CosmicCrystalEntity.isOrbitState(this.getCosmicCrystalState())) {
                orbitPosition = this.getEssenceControllerBlockPos().m_252807_().m_82520_(0.0, -1.0, 0.0);
                if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER && this.targetEntity != null) {
                    Vec3 targetPos = this.targetEntity.m_20182_().m_82520_(0.0, (double)(this.targetEntity.m_20206_() / 2.0f), 0.0);
                    Vec3 diffFromNow = this.prevTargetPosition.m_82546_(targetPos).m_82490_(0.97);
                    this.prevTargetPosition = diffFromNow.m_82549_(targetPos);
                    orbitPosition = new Vec3(orbitPosition.m_7096_(), this.prevTargetPosition.m_7098_() - 1.0, orbitPosition.m_7094_());
                }
            } else {
                return;
            }
            float orbitOffsetDegrees = (float)this.getOrbitOffsetDegrees() * ((float)Math.PI / 180);
            float difficultyBoost = this.getDifficultyBoost();
            float radius = 4.0f;
            if (this.getCosmicCrystalState() == CosmicCrystalState.VERTICAL_LASER) {
                radius = (Math.max(-1.0f, Math.min(1.0f, Mth.m_14031_((float)((float)(this.currentTickCount * 3) * ((float)Math.PI / 180))) * 1.25f)) + 1.0f) * 13.0f;
            }
            float spinRadians = (float)((double)this.currentTickCount * Math.pow(difficultyBoost, 5.0) % 360.0 * 0.01745329238474369);
            Vector3f rotationOffset = POSITIVE_X_VECT.m_252839_().rotateY(orbitOffsetDegrees + spinRadians);
            Vec3 targetOrbitSpot = orbitPosition.m_82549_(new Vec3(rotationOffset).m_82490_((double)radius));
            Vec3 diffToTargetOrbitSpot = targetOrbitSpot.m_82546_(this.m_20182_());
            double xzScale = Math.abs(diffToTargetOrbitSpot.m_165924_()) * 0.05 * (double)difficultyBoost;
            double yScale = Math.abs(diffToTargetOrbitSpot.m_7098_()) * 0.1 * (double)difficultyBoost;
            this.m_20256_(diffToTargetOrbitSpot.m_82541_().m_82542_(xzScale, yScale, xzScale));
        }
    }

    private void spawnFancyParticlesOnClient() {
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 5 == 0 || this.f_20916_ > 0) {
                Vec3 center = this.m_20191_().m_82399_();
                this.spawnFancyParticle(center);
                if (this.f_20916_ == 8) {
                    for (int i = 0; i < 50; ++i) {
                        this.spawnFancyParticle(center);
                    }
                }
            }
            if (this.isLaserFiring()) {
                this.spawnFancyParticle(this.m_146892_().m_82549_(this.m_20154_().m_82490_((double)1.2f)));
            }
        }
    }

    private void incrementAnimationAndRotationTicks() {
        this.prevAnimationTick = this.animationTimeTick;
        if (this.animationTimeTick < this.getInitialRotationAnimationTimespan()) {
            ++this.animationTimeTick;
        } else if (this.getCosmicCrystalState() != CosmicCrystalState.NORMAL && this.currentStateTimeTick >= this.getStateTimespan()) {
            this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
        }
        this.m_6210_();
        this.setupTargetForTrackingStates();
        float progress = this.getInitialRotationAnimationTimespan() == 0 ? 1.0f : (float)this.animationTimeTick / (float)this.getInitialRotationAnimationTimespan();
        this.setActualRotations((float)Math.pow(progress, 4.0));
    }

    private void setActualRotations(float progress) {
        Vec3 currentLookAngle = this.m_20154_();
        Vec3 desiredLookPosition = this.m_146892_().m_82520_(0.0, -1.0, 0.0);
        Vec3 currentLookPosition = this.m_146892_().m_82549_(currentLookAngle);
        if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
            if (this.getEssenceControllerBlockPos() != null) {
                Vec3 anchorPoint = new Vec3((double)this.getEssenceControllerBlockPos().m_123341_() + 0.5, this.m_20188_(), (double)this.getEssenceControllerBlockPos().m_123343_() + 0.5);
                Vec3 diff = this.m_146892_().m_82546_(anchorPoint);
                desiredLookPosition = this.m_146892_().m_82549_(diff);
            } else {
                desiredLookPosition = this.m_146892_().m_82549_(this.m_20171_(0.0f, this.m_146908_()));
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_LASER) {
            if (this.targetEntity != null) {
                Vec3 targetPos = this.targetEntity.m_20182_().m_82520_(0.0, 0.25, 0.0);
                double difficultyMultiplier = (this.getDifficultyBoost() - 1.0f) / 3.0f;
                double targetStrength = 0.94 - difficultyMultiplier;
                Vec3 diffFromNow = this.prevTargetPosition.m_82546_(targetPos).m_82490_(targetStrength);
                this.prevTargetPosition = diffFromNow.m_82549_(targetPos);
                if (diffFromNow.m_82553_() > 3.0) {
                    diffFromNow.m_82490_(3.0 / diffFromNow.m_82553_());
                }
                desiredLookPosition = diffFromNow.m_82549_(targetPos);
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.SWEEP_LASER) {
            Vec3 crossProduct;
            Vec3 targetPos = null;
            Vec3 directionToTarget = null;
            if (this.getEssenceControllerBlockPos() != null) {
                targetPos = this.getEssenceControllerBlockPos().m_252807_();
                directionToTarget = this.m_20182_().m_82546_(targetPos).m_82541_();
            } else if (this.targetEntity != null) {
                if (!this.getSecondPhase()) {
                    this.prevTargetPosition = this.targetEntity.m_20182_().m_82520_(0.0, 0.25, 0.0);
                    this.setSecondPhase(true);
                }
                targetPos = this.prevTargetPosition;
                directionToTarget = this.m_20182_().m_82546_(targetPos).m_82541_();
            }
            if (directionToTarget != null && targetPos != null && (crossProduct = new Vec3(UP_VECT.m_7098_() * directionToTarget.m_7094_() - UP_VECT.m_7094_() * directionToTarget.m_7098_(), UP_VECT.m_7094_() * directionToTarget.m_7096_() - UP_VECT.m_7096_() * directionToTarget.m_7094_(), UP_VECT.m_7096_() * directionToTarget.m_7098_() - UP_VECT.m_7098_() * directionToTarget.m_7096_()).m_82541_()).m_82553_() != 0.0) {
                double difficultyMultiplier = (double)(this.getDifficultyBoost() - 1.0f) * 1.5 + 1.0;
                float spinRadians = (float)((double)(this.currentStateTimeTick * 3) * difficultyMultiplier * 0.01745329238474369);
                Vector3f vectorToRotate = directionToTarget.m_252839_();
                Vector3f axisToRotateAround = crossProduct.m_252839_();
                Vector3f finalLookSpot = vectorToRotate.rotateAxis(spinRadians, axisToRotateAround.x(), axisToRotateAround.y(), axisToRotateAround.z());
                desiredLookPosition = new Vec3(finalLookSpot).m_82549_(this.m_146892_());
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if ((this.currentStateTimeTick <= moveTime || this.getSecondPhase()) && this.targetEntity != null) {
                Vec3 targetPos = this.targetEntity.m_20182_().m_82520_(0.0, 0.25, 0.0);
                Vec3 diffFromNow = this.prevTargetPosition.m_82546_(targetPos).m_82490_(0.9);
                this.prevTargetPosition = diffFromNow.m_82549_(targetPos);
                desiredLookPosition = diffFromNow.m_82549_(targetPos);
            } else {
                desiredLookPosition = this.m_146892_().m_82520_(0.0, -1.0, 0.0);
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK) {
            Vec3 targetPos;
            float windDownDuration = 40.0f;
            int windDownPhase = (int)((float)this.getStateTimespan() - windDownDuration);
            if (this.currentStateTimeTick > windDownPhase) {
                double antiProgress = Math.min((float)(this.currentStateTimeTick - windDownPhase) / windDownDuration, 1.0f);
                float spinStrength = (float)(1.0 - antiProgress);
                targetPos = new Vec3(Mth.m_14139_((double)antiProgress, (double)(Mth.m_14031_((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))) * spinStrength), (double)0.0), Mth.m_14139_((double)antiProgress, (double)1.0, (double)0.0), Mth.m_14139_((double)antiProgress, (double)(Mth.m_14089_((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))) * spinStrength), (double)0.0));
            } else {
                targetPos = new Vec3((double)Mth.m_14031_((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))), (double)Mth.m_14179_((float)progress, (float)0.0f, (float)1.0f), (double)Mth.m_14089_((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))));
            }
            desiredLookPosition = this.m_20182_().m_82549_(targetPos);
        }
        if (!currentLookPosition.equals((Object)desiredLookPosition)) {
            Vec3 lerpedDesiredLook = new Vec3(Mth.m_14139_((double)progress, (double)currentLookPosition.m_7096_(), (double)desiredLookPosition.m_7096_()), Mth.m_14139_((double)progress, (double)currentLookPosition.m_7098_(), (double)desiredLookPosition.m_7098_()), Mth.m_14139_((double)progress, (double)currentLookPosition.m_7094_(), (double)desiredLookPosition.m_7094_()));
            this.lookAtCurrent(lerpedDesiredLook);
        }
    }

    private void lookAtCurrent(Vec3 vec3) {
        Vec3 vec32 = EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)this);
        double d = vec3.f_82479_ - vec32.f_82479_;
        double e = vec3.f_82480_ - vec32.f_82480_;
        double f = vec3.f_82481_ - vec32.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        this.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)e, (double)g) * 57.2957763671875)))));
        this.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        this.m_5616_(this.m_146908_());
    }

    private void setupTargetForTrackingStates() {
        if (CosmicCrystalEntity.isTrackingState(this.getCosmicCrystalState()) && (this.getTargetEntityUUID() == null || this.targetEntity == null || !this.targetEntity.m_20148_().equals(this.getTargetEntityUUID()))) {
            if (this.getTargetEntityUUID() != null) {
                this.targetEntity = this.m_9236_().m_46003_(this.getTargetEntityUUID());
            } else {
                this.targetEntity = this.m_9236_().m_45930_((Entity)this, 30.0);
                if (this.targetEntity != null) {
                    this.setTargetEntityUUID(this.targetEntity.m_20148_());
                    if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
                        this.prevTargetPosition = this.m_20182_();
                    } else if (this.getCosmicCrystalState() != CosmicCrystalState.SWEEP_LASER) {
                        this.prevTargetPosition = this.targetEntity.m_20182_();
                    }
                } else {
                    this.targetEntity = this.m_9236_().m_45963_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(30.0));
                    if (this.targetEntity != null) {
                        this.setTargetEntityUUID(this.targetEntity.m_20148_());
                        if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
                            this.prevTargetPosition = this.m_20182_();
                        } else if (this.getCosmicCrystalState() != CosmicCrystalState.SWEEP_LASER) {
                            this.prevTargetPosition = this.targetEntity.m_20182_();
                        }
                    }
                }
            }
        }
    }

    private void laserBreakBlocks() {
        if (!this.m_9236_().m_5776_() && this.isLaserFiring()) {
            HitResult hitResult = ProjectileUtil.m_278180_((Entity)this, entity -> true, (double)50.0);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockState state = this.m_9236_().m_8055_(blockHitResult.m_82425_());
                if (state.m_60734_().m_7325_() < 1500.0f && !state.m_204336_(BlockTags.f_13070_) && this.m_146911_() == null) {
                    this.m_9236_().m_46961_(blockHitResult.m_82425_(), true);
                }
            } else if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                Entity entity2 = entityHitResult.m_82443_();
                if (entity2 instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity2;
                    itemEntity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.COSMIC_CRYSTAL_TYPE, (Entity)this), 10.0f);
                } else if (entity2 instanceof Projectile) {
                    Projectile projectile = (Projectile)entity2;
                    projectile.m_142687_(Entity.RemovalReason.KILLED);
                } else if (entity2 instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity2;
                    if (!(entity2 instanceof CosmicCrystalEntity) && this.laserHurtAttack(livingEntity)) {
                        return;
                    }
                }
            }
            this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER.get(), SoundSource.HOSTILE, 1.2f, 1.0f);
            this.m_9236_().m_245803_((Entity)this, BlockPos.m_274446_((Position)hitResult.m_82450_()), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER.get(), SoundSource.HOSTILE, 1.2f, 1.0f);
        } else if (!this.laserChargeSoundPlayed && CosmicCrystalEntity.isLaserState(this.getCosmicCrystalState()) && this.currentStateTimeTick > this.getLaserStartDelay() - 10) {
            this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER_CHARGE.get(), SoundSource.HOSTILE, 1.2f, 1.0f);
            this.laserChargeSoundPlayed = true;
        }
    }

    private void smashingBehaviour() {
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if (this.currentStateTimeTick >= this.getStateTimespan() - 1) {
                this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
                this.m_20334_(0.0, 0.0, 0.0);
                this.setCollided(false);
            } else if (this.currentStateTimeTick == moveTime) {
                this.setSecondPhase(true);
            } else if (this.currentStateTimeTick < moveTime) {
                this.m_246865_(new Vec3(0.0, (double)(1.0f - (float)this.currentStateTimeTick / (float)moveTime) * 0.005, 0.0));
            } else if (!this.getSecondPhase() && this.currentStateTimeTick > moveTime && this.currentStateTimeTick < this.getStateTimespan()) {
                this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
                this.m_20334_(0.0, 0.0, 0.0);
                this.setCollided(false);
            } else if (this.targetEntity != null) {
                double crashSpeed = 0.07 * (double)this.getDifficultyBoost();
                this.m_246865_(this.m_20154_().m_82490_(crashSpeed));
                if (this.getCollided() || this.f_19862_ || this.f_19863_ || this.m_20096_()) {
                    this.collidingAttackExplosion();
                }
            } else {
                this.setSecondPhase(false);
            }
        }
    }

    private void collidingAttackExplosion() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.MOB);
            this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_CRASHES.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-2, -2, -2), (BlockPos)this.m_20183_().m_7918_(2, 2, 2))) {
                this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(pos)));
            }
            this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(16.0)).forEach(e -> {
                if (e instanceof Player) {
                    Player player = (Player)e;
                    player.m_269405_(0.0, 0.0);
                }
            });
            this.setCollided(true);
        } else {
            this.spawnLargeParticleCloud(5);
        }
        this.m_20334_(0.0, 0.0, 0.0);
        this.setSecondPhase(false);
    }

    private void spinningTrackingBehaviour() {
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if (this.currentStateTimeTick >= this.getStateTimespan() - 1) {
                this.m_20334_(0.0, 0.0, 0.0);
            } else if (this.targetEntity != null) {
                double progress = this.getInitialRotationAnimationTimespan() == 0 ? 1.0 : (double)((float)this.animationTimeTick / (float)this.getInitialRotationAnimationTimespan());
                progress = Math.pow(progress, 4.0);
                double speedAdj = (double)Math.min(1.0f, (float)this.currentStateTimeTick / (float)moveTime) * progress;
                Vec3 targetPos = this.targetEntity.m_20182_().m_82520_(0.0, (double)(this.targetEntity.m_20206_() / 4.0f), 0.0);
                Vec3 diffFromNow = targetPos.m_82546_(this.m_20182_());
                Vec3 diffFromPast = this.prevTargetPosition.m_82546_(this.m_20182_());
                float turnStrength = 0.0375f + (this.getDifficultyBoost() - 1.0f) / 30.0f;
                Vec3 lerpedLookVector = new Vec3(Mth.m_14139_((double)turnStrength, (double)diffFromPast.m_7096_(), (double)diffFromNow.m_7096_()), Mth.m_14139_((double)turnStrength, (double)diffFromPast.m_7098_(), (double)diffFromNow.m_7098_()), Mth.m_14139_((double)turnStrength, (double)diffFromPast.m_7094_(), (double)diffFromNow.m_7094_()));
                this.prevTargetPosition = lerpedLookVector.m_82549_(targetPos);
                int hitDiff = this.currentStateTimeTick - this.lastPhysicalHit;
                double cappedSpeed = Mth.m_14139_((double)Math.min((float)hitDiff / 40.0f, 1.0f), (double)0.0, (double)0.65) * speedAdj;
                this.m_20256_(lerpedLookVector.m_82541_().m_82490_(cappedSpeed));
                float inflatedSpeed = 2.0f;
                Vec3 originalVect = this.m_20184_();
                Vec3 inflatedVect = originalVect.m_82490_((double)inflatedSpeed);
                Vec3 collideVect = ((EntityAccessor)((Object)this)).bumblezone$callCollide(inflatedVect);
                int xDirection = CosmicCrystalEntity.getDirection(inflatedVect.m_7096_(), collideVect.m_7096_());
                int yDirection = CosmicCrystalEntity.getDirection(inflatedVect.m_7098_(), collideVect.m_7098_());
                int zDirection = CosmicCrystalEntity.getDirection(inflatedVect.m_7094_(), collideVect.m_7094_());
                if (xDirection == -1 || yDirection == -1 || zDirection == -1) {
                    this.m_20334_(originalVect.m_7096_() * (double)xDirection, originalVect.m_7098_() * (double)yDirection, originalVect.m_7094_() * (double)zDirection);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.m_9236_().m_245803_((Entity)this, this.m_20183_(), BzSounds.COSMIC_CRYSTAL_ENTITY_SPIN.get(), SoundSource.HOSTILE, (float)progress, 1.0f);
                }
            }
        }
    }

    private static int getDirection(double originalCoordinate, double collideCoordinate) {
        if (originalCoordinate > 0.0 ? originalCoordinate > collideCoordinate : originalCoordinate < 0.0 && originalCoordinate < collideCoordinate) {
            return -1;
        }
        return 1;
    }

    public void m_6075_() {
        if (this.m_20159_()) {
            this.m_8127_();
        }
        this.f_19867_ = this.f_19787_;
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        if (this.m_9236_().f_46443_) {
            this.m_20095_();
        } else if (this.m_20094_() > 0) {
            if (this.m_20094_() > 25) {
                this.m_7311_(25);
            }
            if (this.m_20094_() == 1 && !this.m_20077_()) {
                this.m_6469_(this.m_269291_().m_269549_(), 1.0f);
            }
            this.m_7311_(this.m_20094_() - 1);
            if (this.m_146888_() > 0) {
                this.m_146917_(0);
                this.m_9236_().m_5898_(null, 1009, this.m_20183_(), 1);
            }
        } else {
            this.m_7311_(-1);
        }
        if (!this.m_9236_().f_46443_ && this.m_146888_() > 0) {
            if (this.f_146809_ && !this.f_146808_ && this.m_142079_()) {
                this.m_146917_(39);
            } else if (this.f_146808_ && this.m_142079_()) {
                if (this.m_146888_() > 39 && this.m_146888_() < 70) {
                    if (this.m_146888_() == 69) {
                        this.m_6469_(this.m_269291_().m_269109_(), 1.0f);
                    }
                } else {
                    this.m_146917_(40);
                }
            }
            if (this.m_146888_() == 1 || this.m_146888_() == 2) {
                this.m_6469_(this.m_269291_().m_269109_(), 1.0f);
            }
        }
        this.f_146809_ = this.f_146808_;
        this.f_146808_ = false;
        if (this.f_20916_ > 0) {
            --this.f_20916_;
        }
        if (this.f_19802_ > 0) {
            --this.f_19802_;
        }
        if (this.f_20889_ > 0) {
            --this.f_20889_;
        } else {
            this.f_20888_ = null;
        }
        if (this.m_21214_() != null && !this.m_21214_().m_6084_()) {
            this.m_6703_(null);
        }
        if (this.m_21188_() != null) {
            if (!this.m_21188_().m_6084_()) {
                this.m_6703_(null);
            } else if (this.f_19797_ - this.m_21213_() > 100) {
                this.m_6703_(null);
            }
        }
        this.f_20895_ = this.f_20894_;
        this.f_20884_ = this.f_20883_;
        this.f_20886_ = this.f_20885_;
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        for (MobEffectInstance mobEffectInstance : new ArrayList(this.m_21220_())) {
            int currentEffectTick;
            MobEffect mobEffect = mobEffectInstance.m_19544_();
            int n = currentEffectTick = mobEffectInstance.m_267577_() ? Integer.MAX_VALUE : mobEffectInstance.m_19557_();
            if (mobEffect == MobEffects.f_19614_) {
                if (currentEffectTick <= 45) continue;
                this.m_147215_(new MobEffectInstance(mobEffect, 45, mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)this);
                continue;
            }
            if (mobEffect == MobEffects.f_19615_) {
                if (currentEffectTick <= 80) continue;
                this.m_147215_(new MobEffectInstance(mobEffect, 80, mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)this);
                continue;
            }
            if (currentEffectTick <= 30 || mobEffectInstance.m_19544_().m_19486_()) continue;
            this.m_147215_(new MobEffectInstance(mobEffect, 30, mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)this);
        }
        this.m_21217_();
        if (!this.m_9236_().f_46443_) {
            this.m_146868_(this.m_20094_() > 0);
        }
        this.f_19803_ = false;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_()) {
            boolean bl;
            double d = 0.08;
            boolean bl2 = bl = this.m_20184_().f_82480_ <= 0.0;
            if (bl && this.m_21023_(MobEffects.f_19591_)) {
                d = 0.01;
            }
            BlockPos blockPos = this.m_20099_();
            float p = this.m_9236_().m_8055_(blockPos).m_60734_().m_49958_();
            float f = this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK ? 0.93f : 0.91f;
            Vec3 vec37 = this.m_21074_(vec3, p);
            double q = vec37.f_82480_;
            if (!this.m_9236_().f_46443_ || this.m_9236_().m_46805_(blockPos)) {
                if (!this.m_20068_()) {
                    q -= d;
                }
            } else {
                q = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
            }
            this.m_20334_(vec37.f_82479_ * (double)f, q * (double)0.98f, vec37.f_82481_ * (double)f);
        }
        this.m_267651_(true);
    }

    protected AABB m_142242_() {
        EntityDimensions entityDimensions = ((EntityAccessor)((Object)this)).bumblezone$getDimensions();
        float radius = entityDimensions.f_20377_ / 2.0f;
        float heightRadius = entityDimensions.f_20378_ / 2.0f;
        float yOffset = 1.0f;
        float progress = 1.0f - Mth.m_14154_((float)((90.0f - this.m_146909_()) / 90.0f - 1.0f));
        if (CosmicCrystalEntity.isOrFromHorizontalState(this.getCosmicCrystalState()) || this.pastStates != null && !this.pastStates.isEmpty() && CosmicCrystalEntity.isOrFromHorizontalState(this.pastStates.getFirst())) {
            float yRotRadian = this.m_146908_() * ((float)Math.PI / 180);
            double yRotSin = Math.abs(Mth.m_14031_((float)yRotRadian));
            double yRotCos = Math.abs(Mth.m_14089_((float)yRotRadian));
            double xRadius = (double)radius + yRotSin * 0.5 * (double)progress;
            double zRadius = (double)radius + yRotCos * 0.5 * (double)progress;
            double xMin = this.m_20185_() - xRadius;
            double yMin = this.m_20186_() + (double)yOffset - (double)(heightRadius -= 0.5f * progress);
            double zMin = this.m_20189_() - zRadius;
            double xMax = this.m_20185_() + xRadius;
            double yMax = this.m_20186_() + (double)yOffset + (double)heightRadius;
            double zMax = this.m_20189_() + zRadius;
            return new AABB(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - (double)radius, this.m_20186_() + (double)yOffset - (double)heightRadius, this.m_20189_() - (double)radius);
        Vec3 vec32 = new Vec3(this.m_20185_() + (double)radius, this.m_20186_() + (double)yOffset + (double)heightRadius, this.m_20189_() + (double)radius);
        return new AABB(vec3, vec32);
    }

    protected void m_20101_() {
        AABB aABB = this.m_20191_();
        BlockPos blockPos = BlockPos.m_274561_((double)(aABB.f_82288_ + 1.0E-7), (double)(aABB.f_82289_ + 1.0E-7), (double)(aABB.f_82290_ + 1.0E-7));
        BlockPos blockPos2 = BlockPos.m_274561_((double)(aABB.f_82291_ - 1.0E-7), (double)(aABB.f_82292_ - 1.0E-7), (double)(aABB.f_82293_ - 1.0E-7));
        if (this.m_9236_().m_46832_(blockPos, blockPos2)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = blockPos.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        mutableBlockPos.m_122178_(i, j, k);
                        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
                        if (!(this.m_9236_().m_5776_() || blockState.m_60795_() || blockState.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos).m_83281_() || !(blockState.m_60734_().m_7325_() < 1500.0f) || blockState.m_204336_(BlockTags.f_13070_))) {
                            if (this.m_146911_() != null) continue;
                            this.m_9236_().m_46961_((BlockPos)mutableBlockPos, true);
                            continue;
                        }
                        try {
                            blockState.m_60682_(this.m_9236_(), (BlockPos)mutableBlockPos, (Entity)this);
                            this.m_6763_(blockState);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)this.m_9236_(), (BlockPos)mutableBlockPos, (BlockState)blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    private void destroyTouchingBlocks() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        AABB aABB = this.m_20191_();
        BlockPos blockPos = BlockPos.m_274561_((double)(aABB.f_82288_ - 1.0E-7), (double)(aABB.f_82289_ - 1.0E-7), (double)(aABB.f_82290_ - 1.0E-7));
        BlockPos blockPos2 = BlockPos.m_274561_((double)(aABB.f_82291_ + 1.0E-7), (double)(aABB.f_82292_ + 1.0E-7), (double)(aABB.f_82293_ + 1.0E-7));
        if (this.m_9236_().m_46832_(blockPos, blockPos2)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = blockPos.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        mutableBlockPos.m_122178_(i, j, k);
                        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
                        if (blockState.m_60795_() || blockState.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos).m_83281_() || !(blockState.m_60734_().m_7325_() < 1500.0f) || blockState.m_204336_(BlockTags.f_13070_) || this.m_146911_() != null) continue;
                        this.m_9236_().m_46961_((BlockPos)mutableBlockPos, true);
                    }
                }
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), this.m_20191_(), EntitySelector.m_20421_((Entity)this)).forEach(x$0 -> this.m_7324_((Entity)x$0));
            return;
        }
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            int entityIndex;
            int maxCrammingLimit = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
            if (maxCrammingLimit > 0 && list.size() > maxCrammingLimit - 1 && this.f_19796_.m_188503_(4) == 0) {
                entityIndex = 0;
                for (Entity entity : list) {
                    if (entity.m_20159_()) continue;
                    ++entityIndex;
                }
            }
            for (entityIndex = 0; entityIndex < list.size(); ++entityIndex) {
                Entity entity = (Entity)list.get(entityIndex);
                this.m_7324_(entity);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof CosmicCrystalEntity || this.physicalHurtAttack(livingEntity)) continue;
                Vec3 center = livingEntity.m_20191_().m_82399_();
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, center.m_7096_() + this.f_19796_.m_188583_() / 5.0, center.m_7098_() + this.f_19796_.m_188583_() / 2.5, center.m_7094_() + this.f_19796_.m_188583_() / 5.0, 15, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * 0.035 + 0.085);
            }
        }
    }

    protected void m_142540_(MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
        super.m_142540_(mobEffectInstance, entity);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6907_().forEach(p -> p.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(this.m_19879_(), mobEffectInstance)));
        }
    }

    protected void m_7285_(MobEffectInstance mobEffectInstance) {
        super.m_7285_(mobEffectInstance);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6907_().forEach(p -> p.f_8906_.m_9829_((Packet)new ClientboundRemoveMobEffectPacket(this.m_19879_(), mobEffectInstance.m_19544_())));
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        return mobEffectInstance.m_19544_() != MobEffects.f_19605_ && mobEffectInstance.m_19544_() != MobEffects.f_19601_ && mobEffectInstance.m_19544_() != MobEffects.f_19617_;
    }

    public void m_6074_() {
        this.m_21153_(0.0f);
        this.m_6667_(this.m_269291_().m_287172_());
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        boolean dealtDamage;
        Entity entity2;
        if (damageAmount >= 30.0f) {
            damageAmount = 2.0f;
        } else if (damageAmount >= 10.0f && !damageSource.m_269014_() && !damageSource.m_269533_(BzTags.COSMIC_CRYSTAL_RESISTANT_TO)) {
            damageAmount = 2.0f;
        } else if (damageAmount > 1.0f) {
            damageAmount = 1.0f;
        }
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (damageSource.m_7639_() instanceof CosmicCrystalEntity || damageSource.m_7640_() instanceof CosmicCrystalEntity) {
            return false;
        }
        if (this.m_21224_()) {
            return false;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268745_) && this.m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        if (this.m_5803_() && !this.m_9236_().f_46443_) {
            this.m_5796_();
        }
        this.f_20891_ = 0;
        boolean bl = false;
        if (this.f_19802_ > 0) {
            return false;
        }
        this.f_20898_ = damageAmount;
        this.f_19802_ = 10;
        this.m_6475_(damageSource, damageAmount);
        this.f_20917_ = 10;
        this.f_20916_ = 10;
        if (damageSource.m_269533_(DamageTypeTags.f_268627_) && !this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            this.m_142642_(damageSource, damageAmount);
            damageAmount *= 0.75f;
        }
        if ((entity2 = damageSource.m_7639_()) != null) {
            TamableAnimal tamableAnimal;
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity2;
                if (!damageSource.m_269533_(DamageTypeTags.f_268718_)) {
                    this.m_6703_(livingEntity2);
                }
            }
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                this.f_20889_ = 100;
                this.f_20888_ = player;
            } else if (entity2 instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity2).m_21824_()) {
                this.f_20889_ = 100;
                LivingEntity livingEntity = tamableAnimal.m_269323_();
                this.f_20888_ = livingEntity instanceof Player ? (Player)livingEntity : null;
            }
        }
        this.m_9236_().m_269196_((Entity)this, damageSource);
        if (!damageSource.m_269533_(DamageTypeTags.f_268467_)) {
            this.m_5834_();
        }
        if (entity2 != null && !damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            double xDiff = entity2.m_20185_() - this.m_20185_();
            double zDiff = entity2.m_20189_() - this.m_20189_();
            while (xDiff * xDiff + zDiff * zDiff < 1.0E-4) {
                xDiff = (Math.random() - Math.random()) * 0.01;
                zDiff = (Math.random() - Math.random()) * 0.01;
            }
            if (!bl) {
                this.m_269405_(xDiff, zDiff);
            }
        }
        if (this.m_21224_()) {
            Block block;
            SoundEvent soundEvent = this.m_5592_();
            if (soundEvent != null) {
                this.m_5496_(soundEvent, this.m_6121_(), this.m_6100_());
            }
            this.m_6667_(damageSource);
            EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.m_9236_(), this.getEssenceControllerDimension(), this.getEssenceControllerBlockPos(), this.getEssenceController());
            if (essenceBlockEntity != null && (block = essenceBlockEntity.m_58900_().m_60734_()) instanceof EssenceBlockWhite) {
                EssenceBlockWhite essenceBlockWhite = (EssenceBlockWhite)block;
                essenceBlockWhite.crystalKilled(this, essenceBlockEntity);
            }
        } else {
            this.m_6677_(damageSource);
        }
        boolean bl2 = dealtDamage = damageAmount > 0.0f;
        if (dealtDamage) {
            ((LivingEntityAccessor)((Object)this)).bumblezone$setLastDamageSource(damageSource);
            ((LivingEntityAccessor)((Object)this)).bumblezone$setLastDamageStamp(this.m_9236_().m_46467_());
        }
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            CriteriaTriggers.f_10573_.m_60112_(serverPlayer, (Entity)this, damageSource, damageAmount, damageAmount, bl);
        }
        return damageAmount > 0.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ / 2.0f;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_21226_() {
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot equipmentSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public boolean m_6052_() {
        return false;
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_20092_() {
        return true;
    }

    public boolean m_5825_() {
        return false;
    }

    public void m_20093_() {
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_5830_() {
        return false;
    }

    protected void m_20157_() {
    }

    public boolean m_142038_() {
        return true;
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getEssenceController() == null;
    }

    public int m_287157_() {
        return this.getEssenceController() == null ? super.m_287157_() : Integer.MAX_VALUE;
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        return this;
    }

    private boolean laserHurtAttack(LivingEntity livingEntity) {
        float damageAmount;
        float maxHealth = Math.max(livingEntity.m_21223_(), livingEntity.m_21233_());
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (serverPlayer.m_7500_()) {
                return true;
            }
            damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 4.0f : maxHealth / 3.0f;
        } else {
            damageAmount = maxHealth / 4.0f;
        }
        livingEntity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.COSMIC_CRYSTAL_TYPE, (Entity)this), damageAmount);
        return false;
    }

    private boolean physicalHurtAttack(LivingEntity livingEntity) {
        float damageAmount;
        float maxHealth = Math.max(livingEntity.m_21223_(), livingEntity.m_21233_());
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK && this.targetEntity == livingEntity) {
            this.collidingAttackExplosion();
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (serverPlayer.m_7500_()) {
                return true;
            }
            damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 6.0f : maxHealth / 4.0f;
        } else {
            damageAmount = maxHealth / 6.0f;
        }
        livingEntity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.COSMIC_CRYSTAL_TYPE, (Entity)this), damageAmount);
        this.lastPhysicalHit = this.currentStateTimeTick;
        for (MobEffect mobEffect : new HashSet(livingEntity.m_21221_().keySet())) {
            if (!mobEffect.m_19486_()) continue;
            livingEntity.m_21195_(mobEffect);
        }
        return false;
    }

    public void m_5634_(float f) {
    }

    public boolean m_6673_(DamageSource damageSource) {
        DamageSources sources = this.m_9236_().m_269111_();
        if (this.getShield() && damageSource != sources.m_269341_() && damageSource != sources.m_287287_()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    protected boolean m_7310_(Entity entity) {
        return false;
    }

    protected boolean m_269011_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    private void spawnLargeParticleCloud(int radius) {
        int radiusSquared = radius * radius;
        for (int xParticle = -radius; xParticle <= radius; ++xParticle) {
            for (int zParticle = -radius; zParticle <= radius; ++zParticle) {
                for (int yParticle = -radius; yParticle <= radius; ++yParticle) {
                    int distanceSquared = xParticle * xParticle + yParticle * yParticle + zParticle * zParticle;
                    if (distanceSquared > radiusSquared) continue;
                    for (int i = 0; i <= radiusSquared / Math.max(1, distanceSquared) * 3; ++i) {
                        this.spawnFancyParticle(this.m_20182_().m_82520_((double)xParticle, (double)yParticle, (double)zParticle));
                    }
                }
            }
        }
    }

    private void spawnFancyParticle(Vec3 center) {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, center.m_7096_() + this.f_19796_.m_188583_() / 5.0, center.m_7098_() + this.f_19796_.m_188583_() / 2.5, center.m_7094_() + this.f_19796_.m_188583_() / 5.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0);
        this.m_9236_().m_7106_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), center.m_7096_() + this.f_19796_.m_188583_() / 4.0, center.m_7098_() + this.f_19796_.m_188583_() / 2.5, center.m_7094_() + this.f_19796_.m_188583_() / 4.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0, (double)this.f_19796_.m_188501_() * this.f_19796_.m_188583_() / 15.0);
    }
}

