/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.StinglessBeeHelmetSightPacket;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StinglessBeeHelmet
extends BeeArmor {
    public static final Set<Entity> BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE = new ObjectArraySet();
    public static int HELMET_EFFECT_COUNTER_CLIENTSIDE = 0;
    public static int BEE_WEARABLES_COUNT = 0;
    public static int PACKET_SEND_COOLDOWN_CLIENTSIDE = 20;

    public StinglessBeeHelmet(ArmorMaterial material, ArmorItem.Type armorType, Item.Properties properties, int variant) {
        super(material, armorType, properties, variant, false);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.BEE_ARMOR_REPAIR_ITEMS);
    }

    public void onArmorTick(ItemStack itemstack, Level world, Player player) {
        this.bz$onArmorTick(itemstack, world, player);
    }

    @Override
    public void bz$onArmorTick(ItemStack itemstack, Level world, Player player) {
        MobEffectInstance poison;
        int i;
        CompoundTag tag = itemstack.m_41784_();
        boolean hasBeeRider = tag.m_128471_("hasBeeRider");
        if (player.m_36335_().m_41519_(itemstack.m_41720_())) {
            if (hasBeeRider) {
                this.ejectAllBeeRiders(world, player, tag);
            }
            return;
        }
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        MobEffectInstance nausea = player.m_21124_(MobEffects.f_19604_);
        if (nausea != null) {
            int decreaseSpeed = (int)((double)beeWearablesCount * 3.0 - 2.0);
            for (i = 0; i < decreaseSpeed; ++i) {
                ((MobEffectInstanceAccessor)nausea).bumblezone$callTickDownDuration();
                if (world.m_5776_() || !(player.m_217043_().m_188501_() < 0.001f) || itemstack.m_41776_() - itemstack.m_41773_() <= 1) continue;
                itemstack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.HEAD));
            }
        }
        if ((poison = player.m_21124_(MobEffects.f_19614_)) != null && (beeWearablesCount >= 4 || world.m_46467_() % (long)(beeWearablesCount == 3 ? 2 : 3) == 0L)) {
            for (i = 0; i <= Math.max(beeWearablesCount - 3, 1); ++i) {
                if (poison.m_19557_() <= 0) continue;
                ((MobEffectInstanceAccessor)poison).bumblezone$callTickDownDuration();
            }
            if (!world.m_5776_() && player.m_217043_().m_188501_() < 0.004f && itemstack.m_41776_() - itemstack.m_41773_() > 1) {
                itemstack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.HEAD));
            }
        }
        if (world.m_5776_()) {
            if (--PACKET_SEND_COOLDOWN_CLIENTSIDE == 0) {
                PACKET_SEND_COOLDOWN_CLIENTSIDE = 20;
                if (BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE.size() >= 50) {
                    StinglessBeeHelmetSightPacket.sendToServer(true);
                }
            }
            BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE.clear();
            BEE_WEARABLES_COUNT = beeWearablesCount;
            if (player.m_6144_() && player.m_20096_()) {
                HELMET_EFFECT_COUNTER_CLIENTSIDE = (beeWearablesCount - 1) * 65 + 6;
            }
        }
        int beeRidingTimer = tag.m_128451_("beeRidingTimer");
        boolean hasWrath = player.m_21023_(BzEffects.WRATH_OF_THE_HIVE.get());
        if (hasBeeRider || hasWrath) {
            if (hasWrath || player.m_5842_() || player.m_6144_() || beeWearablesCount < 4 && beeRidingTimer > beeWearablesCount * 600) {
                this.ejectAllBeeRiders(world, player, tag);
            } else if (!world.m_5776_()) {
                tag.m_128405_("beeRidingTimer", beeRidingTimer + 1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_36220_(BzStats.STINGLESS_BEE_HELMET_BEE_RIDER_RL.get());
                }
            }
        }
    }

    private void ejectAllBeeRiders(Level world, Player player, CompoundTag tag) {
        for (Entity passenger : player.m_20197_()) {
            if ((!(passenger instanceof Bee) || passenger.m_6095_().m_204039_(BzTags.STINGLESS_BEE_HELMET_DISALLOWED_PASSENGERS)) && !passenger.m_6095_().m_204039_(BzTags.STINGLESS_BEE_HELMET_FORCED_ALLOWED_PASSENGERS)) continue;
            passenger.m_8127_();
            if (!(passenger instanceof Mob)) continue;
            Mob mob = (Mob)passenger;
            mob.m_21557_(false);
        }
        if (!world.m_5776_()) {
            tag.m_128379_("hasBeeRider", false);
            tag.m_128405_("beeRidingTimer", 0);
        }
    }

    public static boolean shouldEntityGlow(Player player, Entity entity) {
        if (entity instanceof Bee || entity instanceof BeehemothEntity || entity instanceof BeeQueenEntity) {
            if (player.m_36335_().m_41519_(BzItems.STINGLESS_BEE_HELMET_1.get()) || player.m_36335_().m_41519_(BzItems.STINGLESS_BEE_HELMET_2.get())) {
                return false;
            }
            return entity.m_20183_().m_123314_((Vec3i)player.m_20183_(), (double)BEE_WEARABLES_COUNT * 16.5 + 14.0);
        }
        return false;
    }

    public static InteractionResult addBeePassenger(Level world, Player playerEntity, InteractionHand hand, Entity entity) {
        ItemStack beeHelmet = StinglessBeeHelmet.getEntityBeeHelmet((Entity)playerEntity);
        if (!beeHelmet.m_41619_() && !playerEntity.m_6144_() && playerEntity.m_21120_(playerEntity.m_7655_()).m_41619_() && playerEntity.m_20197_().isEmpty() && !playerEntity.m_36335_().m_41519_(beeHelmet.m_41720_()) && (entity instanceof Bee && !entity.m_6095_().m_204039_(BzTags.STINGLESS_BEE_HELMET_DISALLOWED_PASSENGERS) || entity.m_6095_().m_204039_(BzTags.STINGLESS_BEE_HELMET_FORCED_ALLOWED_PASSENGERS))) {
            entity.m_20329_((Entity)playerEntity);
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
            }
            if (!world.m_5776_()) {
                CompoundTag tag = beeHelmet.m_41784_();
                tag.m_128379_("hasBeeRider", true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static double beeRidingOffset(double yOffset, Entity vehicle, Entity rider) {
        if (vehicle instanceof Player && rider instanceof Bee) {
            return yOffset + (double)0.3f;
        }
        return yOffset;
    }

    public static void decrementHighlightingCounter(Player player) {
        if (player != null && HELMET_EFFECT_COUNTER_CLIENTSIDE > 0) {
            --HELMET_EFFECT_COUNTER_CLIENTSIDE;
            if (StinglessBeeHelmet.getEntityBeeHelmet((Entity)player).m_41619_()) {
                HELMET_EFFECT_COUNTER_CLIENTSIDE = 0;
            }
        }
    }

    public static ItemStack getEntityBeeHelmet(Entity entity) {
        for (ItemStack armor : entity.m_6168_()) {
            if (!(armor.m_41720_() instanceof StinglessBeeHelmet)) continue;
            return armor;
        }
        return ItemStack.f_41583_;
    }
}

