/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules.forge;

import com.telepathicgrunt.the_bumblezone.modules.base.Module;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleFactory;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHolder;
import com.telepathicgrunt.the_bumblezone.modules.base.forge.ForgeModuleHolder;
import com.telepathicgrunt.the_bumblezone.modules.forge.HackyCapabilityManager;
import com.telepathicgrunt.the_bumblezone.modules.forge.ModuleCapabilityProvider;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistrar;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeModuleInitalizer {
    private static final List<ModuleRegistryValue<?, LivingEntity>> LIVING_ENTITY_MODULES = new ArrayList();
    private static final List<ModuleRegistryValue<?, Player>> PLAYER_ENTITY_MODULES = new ArrayList();
    private static final List<ModuleRegistryValue<?, ? extends LivingEntity>> PERSIST_PLAYER_DATA_SAVE_MODULES = new ArrayList();

    public static void init() {
        ModuleRegistry.register(new ModuleRegistrar(){

            @Override
            public <T extends Module<T>> void registerPlayerModule(ModuleHolder<T> holder, ModuleFactory<Player, T> factory, boolean runDataCloneForPlayer) {
                if (holder instanceof ForgeModuleHolder) {
                    ForgeModuleHolder forgeHolder = (ForgeModuleHolder)holder;
                    ModuleRegistryValue<T, Player> moduleRegistryValue = new ModuleRegistryValue<T, Player>(forgeHolder, factory);
                    PLAYER_ENTITY_MODULES.add(moduleRegistryValue);
                    if (runDataCloneForPlayer) {
                        PERSIST_PLAYER_DATA_SAVE_MODULES.add(moduleRegistryValue);
                    }
                }
            }

            @Override
            public <T extends Module<T>> void registerLivingEntityModule(ModuleHolder<T> holder, ModuleFactory<LivingEntity, T> factory, boolean runDataCloneForPlayer) {
                if (holder instanceof ForgeModuleHolder) {
                    ForgeModuleHolder forgeHolder = (ForgeModuleHolder)holder;
                    ModuleRegistryValue<T, LivingEntity> moduleRegistryValue = new ModuleRegistryValue<T, LivingEntity>(forgeHolder, factory);
                    LIVING_ENTITY_MODULES.add(new ModuleRegistryValue<T, LivingEntity>(forgeHolder, factory));
                    if (runDataCloneForPlayer) {
                        PERSIST_PLAYER_DATA_SAVE_MODULES.add(moduleRegistryValue);
                    }
                }
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeModuleInitalizer::onRegisterCapabilties);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, ForgeModuleInitalizer::onEntityAttach);
        MinecraftForge.EVENT_BUS.addListener(ForgeModuleInitalizer::onPlayerClone);
    }

    public static void onRegisterCapabilties(RegisterCapabilitiesEvent event) {
        for (ModuleRegistryValue<?, LivingEntity> moduleRegistryValue : LIVING_ENTITY_MODULES) {
            HackyCapabilityManager.register(moduleRegistryValue.holder().serializer().moduleClass());
        }
        for (ModuleRegistryValue<?, LivingEntity> moduleRegistryValue : PLAYER_ENTITY_MODULES) {
            HackyCapabilityManager.register(moduleRegistryValue.holder().serializer().moduleClass());
        }
    }

    public static void onEntityAttach(AttachCapabilitiesEvent<Entity> event) {
        Iterator<ModuleRegistryValue<?, Player>> iterator = event.getObject();
        if (iterator instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)iterator;
            iterator = PLAYER_ENTITY_MODULES.iterator();
            while (iterator.hasNext()) {
                ModuleRegistryValue<?, Player> moduleRegistryValue = iterator.next();
                ForgeModuleInitalizer.attachHolderOnEntity(event, player, moduleRegistryValue);
            }
        }
        if ((iterator = event.getObject()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)iterator;
            for (ModuleRegistryValue<?, Player> moduleRegistryValue : LIVING_ENTITY_MODULES) {
                ForgeModuleInitalizer.attachHolderOnEntity(event, livingEntity, moduleRegistryValue);
            }
        }
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        Object object = event.getEntity();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            object = event.getOriginal();
            if (object instanceof ServerPlayer) {
                ServerPlayer oldPlayer = (ServerPlayer)object;
                oldPlayer.reviveCaps();
                for (ModuleRegistryValue moduleRegistryValue : PERSIST_PLAYER_DATA_SAVE_MODULES) {
                    ForgeModuleInitalizer.copyData(moduleRegistryValue.holder.capability(), oldPlayer, player, !event.isWasDeath());
                }
                oldPlayer.invalidateCaps();
            }
        }
    }

    private static <T extends Module<T>> void copyData(Capability<T> capability, ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean loseless) {
        oldPlayer.getCapability(capability).ifPresent(oldModule -> newPlayer.getCapability(capability).ifPresent(newModule -> newModule.serializer().onPlayerCopy((Module)oldModule, (Module)newModule, newPlayer, loseless)));
    }

    private static <T extends Module<T>, I> void attachHolderOnEntity(AttachCapabilitiesEvent<Entity> event, I input, ModuleRegistryValue<T, I> value) {
        T o = value.factory().create(input);
        event.addCapability(value.holder().serializer().id(), new ModuleCapabilityProvider<T>(value.holder(), o));
    }

    private record ModuleRegistryValue<T extends Module<T>, I>(ForgeModuleHolder<T> holder, ModuleFactory<I, T> factory) {
    }
}

