/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public abstract class TrackBaseBlock<BE extends TrackBaseBlockEntity>
extends RotatedPillarKineticBlock
implements ITransformableBlock,
IBE<BE> {
    public static final Property<TrackPart> PART = EnumProperty.m_61587_((String)"part", TrackPart.class);
    public static final BooleanProperty CONNECTED_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;

    public TrackBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isValidAxis(Direction.Axis axis) {
        return !axis.m_122478_();
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (((Boolean)TrackworkConfigs.server().enableTrackThrow.get()).booleanValue()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.throwTrack(false));
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{PART, CONNECTED_ALONG_FIRST_COORDINATE}));
    }

    public static void updateTrackSystem(BlockPos pos) {
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis;
        Direction.Axis placedAxis = context.m_7820_().m_122434_();
        Direction.Axis axis2 = axis = context.m_43723_() != null && context.m_43723_().m_6144_() ? placedAxis : TrackBaseBlock.getPreferredAxis((BlockPlaceContext)context);
        if (axis == null) {
            axis = placedAxis;
        }
        if (axis == Direction.Axis.Y) {
            axis = Direction.Axis.X;
        }
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)axis);
        for (Direction facing : Iterate.directions) {
            if (facing.m_122434_() == axis) continue;
            BlockPos pos = context.m_8083_();
            BlockPos offset = pos.m_121945_(facing);
            state = this.m_7417_(state, facing, context.m_43725_().m_8055_(offset), (LevelAccessor)context.m_43725_(), pos, offset);
        }
        return state;
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, Direction face, @NotNull BlockState neighbour, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction.Axis otherConnectionAxis;
        boolean positive;
        TrackPart part = (TrackPart)((Object)stateIn.m_61143_(PART));
        Direction.Axis axis = (Direction.Axis)stateIn.m_61143_((Property)AXIS);
        boolean connectionAlongFirst = (Boolean)stateIn.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        Direction.Axis faceAxis = face.m_122434_();
        boolean facingAlongFirst = axis == Direction.Axis.X ? faceAxis.m_122478_() : faceAxis == Direction.Axis.X;
        boolean bl = positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (axis == faceAxis) {
            return stateIn;
        }
        if (!(neighbour.m_60734_() instanceof TrackBaseBlock)) {
            if (facingAlongFirst != connectionAlongFirst || part == TrackPart.NONE) {
                return stateIn;
            }
            if (part == TrackPart.MIDDLE) {
                return (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)(positive ? TrackPart.END : TrackPart.START)));
            }
            if (part == TrackPart.START == positive) {
                return (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)TrackPart.NONE));
            }
            return stateIn;
        }
        TrackPart otherPart = (TrackPart)((Object)neighbour.m_61143_(PART));
        Direction.Axis otherAxis = (Direction.Axis)neighbour.m_61143_((Property)AXIS);
        boolean otherConnection = (Boolean)neighbour.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis axis2 = otherConnection ? (otherAxis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (otherConnectionAxis = otherAxis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        if (neighbour.m_61143_((Property)AXIS) == faceAxis) {
            return stateIn;
        }
        if (otherPart != TrackPart.NONE && otherConnectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == TrackPart.NONE) {
            TrackPart trackPart = part = positive ? TrackPart.START : TrackPart.END;
            connectionAlongFirst = axis == Direction.Axis.X ? faceAxis.m_122478_() : faceAxis == Direction.Axis.X;
        } else if (connectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == TrackPart.START != positive) {
            part = TrackPart.MIDDLE;
        }
        return (BlockState)((BlockState)stateIn.m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(connectionAlongFirst));
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (originalState.m_61143_(PART) == TrackPart.NONE) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        return super.getRotatedBlockState(originalState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)TrackBaseBlock.getConnectionAxis(originalState)));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == state.m_61143_((Property)AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    public static boolean areBlocksConnected(BlockState state, BlockState other, Direction facing) {
        TrackPart part = (TrackPart)((Object)state.m_61143_(PART));
        Direction.Axis connectionAxis = TrackBaseBlock.getConnectionAxis(state);
        Direction.Axis otherConnectionAxis = TrackBaseBlock.getConnectionAxis(other);
        if (otherConnectionAxis != connectionAxis) {
            return false;
        }
        if (facing.m_122434_() != connectionAxis) {
            return false;
        }
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE && (part == TrackPart.MIDDLE || part == TrackPart.START)) {
            return true;
        }
        return facing.m_122421_() == Direction.AxisDirection.NEGATIVE && (part == TrackPart.MIDDLE || part == TrackPart.END);
    }

    protected static Direction.Axis getConnectionAxis(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        boolean connectionAlongFirst = (Boolean)state.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        return connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
    }

    public static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        float fromMod = 1.0f;
        float toMod = 1.0f;
        if (from instanceof ITrackPointProvider) {
            fromMod = ((ITrackPointProvider)from).getWheelRadius();
        }
        if (to instanceof ITrackPointProvider) {
            toMod = ((ITrackPointProvider)to).getWheelRadius();
        }
        return fromMod / toMod;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, rot, Direction.Axis.Y);
    }

    protected BlockState rotate(BlockState pState, Rotation rot, Direction.Axis rotAxis) {
        Direction.Axis connectionAxis = TrackBaseBlock.getConnectionAxis(pState);
        Direction direction = Direction.m_122387_((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction normal = Direction.m_122387_((Direction.Axis)((Direction.Axis)pState.m_61143_((Property)AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        for (int i = 0; i < rot.ordinal(); ++i) {
            direction = direction.m_175362_(rotAxis);
            normal = normal.m_175362_(rotAxis);
        }
        if (direction.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            pState = this.reversePart(pState);
        }
        Direction.Axis newAxis = normal.m_122434_();
        Direction.Axis newConnectingDirection = direction.m_122434_();
        boolean alongFirst = newAxis == Direction.Axis.X && newConnectingDirection == Direction.Axis.Y || newAxis != Direction.Axis.X && newConnectingDirection == Direction.Axis.X;
        return (BlockState)((BlockState)pState.m_61124_((Property)AXIS, (Comparable)newAxis)).m_61124_((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, Mirror pMirror) {
        Direction.Axis connectionAxis = TrackBaseBlock.getConnectionAxis(pState);
        if (pMirror.m_54848_(Direction.m_122387_((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122421_() == Direction.AxisDirection.POSITIVE) {
            return pState;
        }
        return this.reversePart(pState);
    }

    protected BlockState reversePart(BlockState pState) {
        TrackPart part = (TrackPart)((Object)pState.m_61143_(PART));
        if (part == TrackPart.START) {
            return (BlockState)pState.m_61124_(PART, (Comparable)((Object)TrackPart.END));
        }
        if (part == TrackPart.END) {
            return (BlockState)pState.m_61124_(PART, (Comparable)((Object)TrackPart.START));
        }
        return pState;
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        return this.rotate(this.m_6943_(state, transform.mirror), transform.rotation, transform.rotationAxis);
    }

    public static enum TrackPart implements StringRepresentable
    {
        START,
        MIDDLE,
        END,
        NONE;


        @NotNull
        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

