/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlock;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlockEntity;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SimpleWheelRenderer
extends KineticBlockEntityRenderer<WheelBlockEntity> {
    public SimpleWheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(WheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean springFlip;
        BlockState state = be.m_58900_();
        Direction.Axis rotationAxis = SimpleWheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        BlockPos visualPos = be.m_58899_();
        float angleForBE = SimpleWheelRenderer.getAngleForBE(be, visualPos, rotationAxis, partialTicks);
        Direction trackDir = (Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        float axisMult = -1.0f;
        if (trackDir.m_122434_() == Direction.Axis.X) {
            axisMult = 1.0f;
        }
        float horizontalOffset = be.getPointHorizontalOffset();
        float axialOffset = be.getPointAxialOffset();
        boolean bl = springFlip = trackDir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (!springFlip) {
            angleForBE *= -1.0f;
        } else {
            horizontalOffset *= -1.0f;
            axialOffset *= -1.0f;
        }
        float yRot = ((Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122435_();
        float wheelTravel = be.getWheelTravel(partialTicks) - be.getWheelRadius();
        double wheelTuck = Math.sqrt(2.25 - (double)Math.min(1.0f, wheelTravel * wheelTravel)) - 1.5 - (double)axialOffset;
        SimpleWheelRenderer.ribTransform(CachedBufferer.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_RIB, (BlockState)state), yRot, wheelTravel, ms, buffer, light, new Vec3((double)(horizontalOffset * -axisMult), 0.0, (double)axialOffset), springFlip);
        SimpleWheelRenderer.ribTransform(CachedBufferer.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_RIB_UPPER, (BlockState)state), yRot, wheelTravel, ms, buffer, light, new Vec3((double)(horizontalOffset * -axisMult), -0.5625, (double)axialOffset), false);
        BiConsumer<SuperByteBuffer, Float> springTransform = (spring, angle) -> ((SuperByteBuffer)spring.translate(0.0, 0.875, 0.375).translate(0.0, -0.4375, 0.75).rotateX((double)angle.floatValue())).translate(0.0, -0.4375, -0.75);
        float springBaseLength = 0.25f;
        float springEndPointLength = 0.75f;
        double diagonalLength = Math.sqrt(springEndPointLength * springEndPointLength + springBaseLength * springBaseLength);
        double diagonalRibOffset = -Math.atan(springBaseLength);
        double diagonalSpringOffset = 1.5707963267948966 - Math.abs(diagonalRibOffset);
        double ribAngle = Math.atan((double)(wheelTravel + 0.3f) / 1.1);
        double scaleLength = Math.sqrt((double)(springEndPointLength * springEndPointLength) + diagonalLength * diagonalLength - (double)(2.0f * springEndPointLength) * diagonalLength * Math.cos(1.5707963267948966 + ribAngle - diagonalRibOffset));
        if (state.m_61138_(WheelBlock.VISUAL_VARIANT) && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.NO_SPRING) {
            float springAngle = (float)Math.toDegrees(Math.asin((double)springEndPointLength * Math.sin(1.5707963267948966 + ribAngle - diagonalRibOffset) / scaleLength) + diagonalSpringOffset - 1.5707963267948966);
            SuperByteBuffer springBase = CachedBufferer.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_SPRING_BASE, (BlockState)state);
            ((SuperByteBuffer)springBase.centre()).rotateY((double)(-yRot));
            springTransform.accept(springBase, Float.valueOf(0.0f));
            springBase.translate((double)((springFlip ? 0.75f : 0.0f) + horizontalOffset * -axisMult), 0.0, (double)axialOffset).unCentre();
            springBase.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            SuperByteBuffer springCoil = CachedBufferer.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_SPRING_COIL, (BlockState)state);
            ((SuperByteBuffer)springCoil.centre()).rotateY((double)(-yRot));
            springTransform.accept(springCoil, Float.valueOf(springAngle));
            springCoil.translate((double)((springFlip ? 0.75f : 0.0f) + horizontalOffset * -axisMult), 0.4375, (double)axialOffset).scale(1.0f, (float)scaleLength / 1.0625f, 1.0f).translate(0.0, -0.4375, 0.0).unCentre();
            springCoil.renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        }
        SuperByteBuffer wheels = be.getWheelRadius() > 0.8f ? CachedBufferer.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL, (BlockState)state) : CachedBufferer.partial((PartialModel)TrackworkPartialModels.MED_SIMPLE_WHEEL, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheels.centre()).rotateY((double)(-yRot + be.getSteeringValue() * 30.0f))).translate((double)(horizontalOffset * -axisMult), (double)(-wheelTravel) - 0.5, -wheelTuck).rotateZ((double)(-angleForBE))).unCentre();
        wheels.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
    }

    public static void ribTransform(SuperByteBuffer rib, float yRot, float wheelTravel, PoseStack ms, MultiBufferSource buffer, int light, Vec3 offset, boolean flip) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)rib.centre()).rotateY((double)(-yRot))).translate(offset.f_82479_, -0.5 - offset.f_82480_, 1.5 + offset.f_82481_).rotateX(-Math.toDegrees(Math.atan((double)(wheelTravel + 0.3f) / 1.1)))).translate(0.0, 0.5 + offset.f_82480_, -1.375).unCentre();
        rib.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForBE(WheelBlockEntity be, BlockPos pos, Direction.Axis axis, float partialTick) {
        if (be.isFreespin) {
            return be.getFreeWheelAngle(partialTick);
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float offset = SimpleWheelRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
        return (time * be.getWheelSpeed() * 3.0f / 10.0f + offset) % 360.0f;
    }

    protected BlockState getRenderedBlockState(WheelBlockEntity be) {
        return SimpleWheelRenderer.shaft((Direction.Axis)SimpleWheelRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public int m_142163_() {
        return (Integer)TrackworkConfigs.client().trackRenderDist.get();
    }
}

