/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.client.TrackworkSpriteShifts;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrackBeltRenderer {
    public static void renderBelt(TrackBaseBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, ScalableScroll scroll) {
        if (be.isDetracked()) {
            return;
        }
        BlockState state = be.m_58900_();
        float yRot = TrackBeltRenderer.getYRotFromState(state);
        TrackBeltRenderer.renderLink(be, partialTicks, state, yRot, light, ms, buffer, scroll);
    }

    private static void renderLink(ITrackPointProvider fromTrack, float partialTicks, BlockState state, float yRot, int light, PoseStack ms, MultiBufferSource buf, ScalableScroll scroll) {
        boolean isLarge = fromTrack.isBeltLarge();
        float largeScale = isLarge ? 2.0f : 2.0f * fromTrack.getWheelRadius();
        TrackBaseBlock.TrackPart part = (TrackBaseBlock.TrackPart)((Object)state.m_61143_(TrackBaseBlock.PART));
        if (part == TrackBaseBlock.TrackPart.MIDDLE) {
            SuperByteBuffer topLink = TrackBeltRenderer.getLink(state);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)topLink.centre()).rotateY((double)yRot)).rotateX(180.0)).translate(0.0, -0.53125 * (double)largeScale, -0.5).scale(1.0f, largeScale, 1.0f).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(1.0f)).unCentre();
            topLink.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
            SuperByteBuffer flatlink = TrackBeltRenderer.getLink(state);
            ((SuperByteBuffer)((SuperByteBuffer)flatlink.centre()).rotateY((double)yRot)).translate(0.0, -0.5, -0.25).translate(0.0, (double)(-fromTrack.getPointDownwardOffset(partialTicks)), (double)fromTrack.getPointHorizontalOffset()).scale(1.0f, largeScale, 0.5f).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(0.5f)).unCentre();
            flatlink.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
        } else if (fromTrack.getTrackPointType() == ITrackPointProvider.PointType.WRAP) {
            float flip = part == TrackBaseBlock.TrackPart.END ? -1.0f : 1.0f;
            SuperByteBuffer topLink = TrackBeltRenderer.getLink(state);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)topLink.centre()).rotateY((double)yRot)).rotateX(180.0)).translate(0.0, -0.53125 * (double)largeScale, -0.5).scale(1.0f, largeScale, 0.75f + largeScale / 16.0f).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(flip)).unCentre();
            topLink.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
            SuperByteBuffer wrapLink = CachedBufferer.partial((PartialModel)TrackworkPartialModels.TRACK_WRAP, (BlockState)state);
            ((SuperByteBuffer)((SuperByteBuffer)wrapLink.centre()).rotateY((double)yRot)).scale(1.0f, largeScale, largeScale).translate(0.0, 0.5625, (double)fromTrack.getWheelRadius() > 0.667 ? 0.03125 : -0.0625).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(flip)).unCentre();
            wrapLink.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
        }
        if (fromTrack.getNextPoint() != ITrackPointProvider.PointType.NONE) {
            Vec3 offset = fromTrack.getTrackPointSlope(partialTicks);
            float opposite = (float)offset.f_82480_;
            float adjacent = 1.0f + (float)offset.f_82481_;
            SuperByteBuffer link = TrackBeltRenderer.getLink(state);
            if (fromTrack.getNextPoint() == fromTrack.getTrackPointType()) {
                float cut_adjacent = 0.5f + (float)offset.f_82481_;
                float length = (float)Math.sqrt(opposite * opposite + cut_adjacent * cut_adjacent);
                float angleOffset = (float)Math.atan2(opposite, cut_adjacent);
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)link.centre()).rotateY((double)yRot)).translate(0.0, -0.5, 0.25).translate(0.0, (double)(-fromTrack.getPointDownwardOffset(partialTicks)), (double)fromTrack.getPointHorizontalOffset()).rotateX((double)(angleOffset * 180.0f) / Math.PI)).scale(1.0f, largeScale, length).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(length)).unCentre();
                link.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
            } else {
                float length = (float)Math.sqrt(opposite * opposite + adjacent * adjacent + (isLarge ? 0.25f : 0.0f));
                float flip = part == TrackBaseBlock.TrackPart.START ? -1.0f : 1.0f;
                float angleOffset = (float)Math.atan2(opposite, adjacent + (isLarge ? 0.125f : 0.0f));
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)link.centre()).rotateY((double)yRot)).translate(0.0, -0.5, (double)((0.3125f + (isLarge && fromTrack.getTrackPointType() == ITrackPointProvider.PointType.WRAP ? 0.125f : 0.0f)) * flip)).translate(0.0, (double)(-fromTrack.getPointDownwardOffset(partialTicks)), (double)fromTrack.getPointHorizontalOffset()).rotateX((double)(angleOffset * 180.0f) / Math.PI)).scale(1.0f, largeScale, length).shiftUVScrolling(TrackworkSpriteShifts.BELT, scroll.getAtScale(length)).unCentre();
                link.light(light).renderInto(ms, buf.m_6299_(RenderType.m_110451_()));
            }
        }
    }

    private static SuperByteBuffer getLink(BlockState state) {
        return CachedBufferer.partial((PartialModel)TrackworkPartialModels.TRACK_LINK, (BlockState)state);
    }

    public static Direction getAlong(BlockState state) {
        return state.m_61143_((Property)RotatedPillarKineticBlock.AXIS) == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
    }

    public static float getYRotFromState(BlockState state) {
        Direction.Axis trackAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        boolean flip = state.m_61143_(TrackBaseBlock.PART) == TrackBaseBlock.TrackPart.END;
        return (trackAxis == Direction.Axis.X ? 0 : 90) + (flip ? 180 : 0);
    }

    public static class ScalableScroll {
        private final float trueSpeed;
        private final float time;
        private final float spriteSize;
        private final float scrollMult;

        public ScalableScroll(KineticBlockEntity be, float speed, Direction.Axis axis) {
            this.trueSpeed = axis == Direction.Axis.X ? speed : -speed;
            this.time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) * 1.0f;
            this.scrollMult = 0.5f;
            SpriteShiftEntry spriteShift = TrackworkSpriteShifts.BELT;
            this.spriteSize = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
        }

        public float getAtScale(float scale) {
            float speed = this.trueSpeed / scale;
            if (speed != 0.0f) {
                double scroll = (double)(speed * this.time) / 504.0;
                scroll -= Math.floor(scroll);
                scroll = scroll * (double)this.spriteSize * (double)this.scrollMult;
                return (float)scroll;
            }
            return 0.0f;
        }
    }
}

