/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

public class FastMinMaxMap {
    private final int[] backing;
    private final int capacity;
    private int front;
    private int back;
    private int size;

    public FastMinMaxMap(int capacity) {
        this.backing = new int[capacity * 3];
        this.capacity = capacity;
        this.front = -1;
        this.back = -1;
        this.size = 0;
        this.clear();
    }

    public void increment(int key) {
        int n2 = this.getValue(key);
        if (this.size == 0) {
            this.front = this.back = key;
            this.setPrev(key, -1);
            this.setNext(key, -1);
        } else if (n2 == 0) {
            if (key < this.front) {
                this.setPrev(this.front, key);
                this.setNext(key, this.front);
                this.front = key;
            } else if (key > this.back) {
                this.setNext(this.back, key);
                this.setPrev(key, this.back);
                this.back = key;
            } else {
                int n3;
                int n4 = -1;
                for (n3 = key - 1; n3 >= 0; --n3) {
                    if (this.getValue(n3) == 0) continue;
                    n4 = n3;
                    break;
                }
                n3 = this.getNext(n4);
                this.setNext(key, n3);
                this.setPrev(key, n4);
                this.setNext(n4, key);
                this.setPrev(n3, key);
            }
        }
        this.setValue(key, n2 + 1);
        ++this.size;
    }

    public void decrement(int key) {
        if (this.size <= 0) {
            throw new IllegalArgumentException("Cannot decrement when list is empty");
        }
        int n2 = this.getValue(key);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Cannot store negative values");
        }
        if (n2 == 1) {
            if (this.size == 1) {
                this.setNext(key, -1);
                this.setPrev(key, -1);
                this.front = -1;
                this.back = -1;
            } else if (key == this.front) {
                int n3 = this.getNext(this.front);
                this.setNext(this.front, -1);
                this.setPrev(n3, -1);
                this.front = n3;
            } else if (key == this.back) {
                int n4 = this.getPrev(this.back);
                this.setPrev(this.back, -1);
                this.setNext(n4, -1);
                this.back = n4;
            } else {
                int n5 = this.getPrev(key);
                int n6 = this.getNext(key);
                this.setNext(n5, n6);
                this.setPrev(n6, n5);
            }
            this.setValue(key, 0);
        } else {
            this.setValue(key, n2 - 1);
        }
        --this.size;
    }

    private void setValue(int key, int value) {
        this.ensureCapacity(key * 3);
        this.backing[key * 3] = value;
    }

    private void setPrev(int key, int prev) {
        this.ensureCapacity(key * 3 + 1);
        this.backing[key * 3 + 1] = prev;
    }

    private void setNext(int key, int next) {
        this.ensureCapacity(key * 3 + 2);
        this.backing[key * 3 + 2] = next;
    }

    private int getValue(int key) {
        this.ensureCapacity(key * 3);
        return this.backing[key * 3];
    }

    private int getPrev(int key) {
        this.ensureCapacity(key * 3 + 1);
        return this.backing[key * 3 + 1];
    }

    private int getNext(int key) {
        this.ensureCapacity(key * 3 + 2);
        return this.backing[key * 3 + 2];
    }

    private void ensureCapacity(int key) {
        if (key < 0 || key > this.capacity * 3) {
            throw new IllegalArgumentException("Cannot store key of value " + key);
        }
    }

    public void clear() {
        this.size = 0;
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            this.setValue(i2, 0);
            this.setPrev(i2, -1);
            this.setNext(i2, -1);
        }
    }

    public int getFront() {
        return this.front;
    }

    public int getBack() {
        return this.back;
    }
}

