/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.chunk_tracking.ShipActiveChunksSet;
import org.valkyrienskies.core.impl.datastructures.DynamicBlockPosSetAABB;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.core.impl.game.BlockTypeImpl;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.shadow.zB;
import org.valkyrienskies.core.impl.shadow.zD;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 f2\u00020\u00012\u00020\u0002:\u0001fB\u0099\u0001\u0012\n\u0010S\u001a\u00060Qj\u0002`R\u0012\b\u0010U\u001a\u0004\u0018\u00010T\u0012\u0006\u0010W\u001a\u00020V\u0012\n\u0010Y\u001a\u00060Tj\u0002`X\u0012\u0006\u0010[\u001a\u00020Z\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010]\u001a\u00020\\\u0012\u0006\u0010^\u001a\u00020\\\u0012\u0006\u0010`\u001a\u00020_\u0012\b\u0010b\u001a\u0004\u0018\u00010a\u0012\u0006\u0010c\u001a\u000202\u0012\b\b\u0002\u00100\u001a\u00020\u0003\u0012\b\b\u0002\u0010&\u001a\u00020\u0003\u0012\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020605\u0012\b\b\u0002\u0010;\u001a\u00020\r\u00a2\u0006\u0004\bd\u0010eJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000b\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012JO\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0012J-\u0010!\u001a\u00020\u0010\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\b\u0010 \u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b!\u0010\"J/\u0010$\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00038\u0017@\u0017X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010\u0005\"\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\"\u00100\u001a\u00020\u00038\u0017@\u0017X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010'\u001a\u0004\b0\u0010\u0005\"\u0004\b1\u0010*R\u0014\u00103\u001a\u0002028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R \u00107\u001a\b\u0012\u0004\u0012\u000206058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\"\u0010;\u001a\u00020\r8\u0001@\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010B\u001a\u00020A8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010G\u001a\u00020D8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR$\u0010I\u001a\u0004\u0018\u00010H8\u0017@\u0017X\u0097\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0014\u0010P\u001a\u00020D8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010F"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "Lorg/valkyrienskies/core/impl/shadow/zB;", "", "areVoxelsFullyLoaded", "()Z", "asShipDataCommon", "()Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "T", "Ljava/lang/Class;", "clazz", "getAttachment", "(Ljava/lang/Class;)Ljava/lang/Object;", "", "chunkX", "chunkZ", "", "onLoadChunk", "(II)V", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "onUnloadChunk", "value", "saveAttachment", "(Ljava/lang/Class;Ljava/lang/Object;)V", "set", "updateShipAABBGenerator", "(IIIZ)V", "enableKinematicVelocity", "Z", "getEnableKinematicVelocity", "setEnableKinematicVelocity", "(Z)V", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "inertiaData", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "getInertiaData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "isStatic", "setStatic", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "missingLoadedChunks", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "Lcom/google/common/collect/MutableClassToInstanceMap;", "", "persistentAttachedData", "Lcom/google/common/collect/MutableClassToInstanceMap;", "getPersistentAttachedData", "()Lcom/google/common/collect/MutableClassToInstanceMap;", "portalCoolDown", "I", "getPortalCoolDown$impl", "()I", "setPortalCoolDown$impl", "(I)V", "Lorg/valkyrienskies/core/impl/datastructures/IBlockPosSetAABB;", "shipAABBGenerator", "Lorg/valkyrienskies/core/impl/datastructures/IBlockPosSetAABB;", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "Lorg/valkyrienskies/core/api/ships/ServerShipTransformProvider;", "transformProvider", "Lorg/valkyrienskies/core/api/ships/ServerShipTransformProvider;", "getTransformProvider", "()Lorg/valkyrienskies/core/api/ships/ServerShipTransformProvider;", "setTransformProvider", "(Lorg/valkyrienskies/core/api/ships/ServerShipTransformProvider;)V", "getWorldToShip", "worldToShip", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "id", "", "slug", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "physicsData", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipTransform", "prevTickShipTransform", "Lorg/joml/primitives/AABBdc;", "shipAABB", "Lorg/joml/primitives/AABBic;", "shipVoxelAABB", "shipActiveChunksSet", "<init>", "(JLjava/lang/String;Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/primitives/AABBdc;Lorg/joml/primitives/AABBic;Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;ZZLcom/google/common/collect/MutableClassToInstanceMap;I)V", "Companion"})
public final class ShipData
extends ShipDataCommon
implements zB {
    public static final Companion Companion = new Companion(null);
    @PacketIgnore
    private final ShipInertiaDataImpl inertiaData;
    private boolean isStatic;
    private boolean enableKinematicVelocity;
    private final MutableClassToInstanceMap<Object> persistentAttachedData;
    private int portalCoolDown;
    @JsonIgnore
    private final IShipActiveChunksSet missingLoadedChunks;
    @JsonIgnore
    private final IBlockPosSetAABB shipAABBGenerator;
    @JsonIgnore
    private ServerShipTransformProvider transformProvider;

    public ShipData(long id2, String slug, ChunkClaim chunkClaim, String chunkClaimDimension, ShipPhysicsData physicsData, ShipInertiaDataImpl inertiaData, ShipTransform shipTransform, ShipTransform prevTickShipTransform, AABBdc shipAABB, AABBic shipVoxelAABB, IShipActiveChunksSet shipActiveChunksSet, boolean isStatic, boolean enableKinematicVelocity, MutableClassToInstanceMap<Object> persistentAttachedData, int portalCoolDown) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"");
        Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"");
        Intrinsics.checkNotNullParameter((Object)physicsData, (String)"");
        Intrinsics.checkNotNullParameter((Object)inertiaData, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"");
        Intrinsics.checkNotNullParameter((Object)prevTickShipTransform, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipAABB, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipActiveChunksSet, (String)"");
        Intrinsics.checkNotNullParameter(persistentAttachedData, (String)"");
        super(id2, slug, chunkClaim, chunkClaimDimension, physicsData, shipTransform, prevTickShipTransform, shipAABB, shipVoxelAABB, shipActiveChunksSet);
        this.inertiaData = inertiaData;
        this.isStatic = isStatic;
        this.enableKinematicVelocity = enableKinematicVelocity;
        this.persistentAttachedData = persistentAttachedData;
        this.portalCoolDown = portalCoolDown;
        this.missingLoadedChunks = ShipActiveChunksSet.a.a();
        this.shipAABBGenerator = new DynamicBlockPosSetAABB(null, 1, null);
        shipActiveChunksSet.forEach((arg_0, arg_1) -> ShipData._init_$lambda$0(this, arg_0, arg_1));
        for (Map.Entry entry : ((Map)this.persistentAttachedData).entrySet()) {
            if (!zD.class.isAssignableFrom((Class)entry.getKey()) || entry.getValue() == null) continue;
            Object v2 = entry.getValue();
            Intrinsics.checkNotNull(v2);
            if (((zD)v2).a() != null) continue;
            Object v3 = entry.getValue();
            Intrinsics.checkNotNull(v3);
            ((zD)v3).a(this);
        }
    }

    public /* synthetic */ ShipData(long l2, String string, ChunkClaim chunkClaim, String string2, ShipPhysicsData shipPhysicsData, ShipInertiaDataImpl shipInertiaDataImpl, ShipTransform shipTransform, ShipTransform shipTransform2, AABBdc aABBdc, AABBic aABBic, IShipActiveChunksSet iShipActiveChunksSet, boolean bl2, boolean bl3, MutableClassToInstanceMap mutableClassToInstanceMap, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x800) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x1000) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x2000) != 0) {
            MutableClassToInstanceMap mutableClassToInstanceMap2 = MutableClassToInstanceMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)mutableClassToInstanceMap2, (String)"");
            mutableClassToInstanceMap = mutableClassToInstanceMap2;
        }
        if ((n3 & 0x4000) != 0) {
            n2 = 0;
        }
        this(l2, string, chunkClaim, string2, shipPhysicsData, shipInertiaDataImpl, shipTransform, shipTransform2, aABBdc, aABBic, iShipActiveChunksSet, bl2, bl3, (MutableClassToInstanceMap<Object>)mutableClassToInstanceMap, n2);
    }

    @JvmName(name="getInertiaData")
    public ShipInertiaDataImpl getInertiaData() {
        return this.inertiaData;
    }

    @JvmName(name="isStatic")
    public boolean isStatic() {
        return this.isStatic;
    }

    @JvmName(name="setStatic")
    public void setStatic(boolean bl2) {
        this.isStatic = bl2;
    }

    @JvmName(name="getEnableKinematicVelocity")
    public boolean getEnableKinematicVelocity() {
        return this.enableKinematicVelocity;
    }

    @JvmName(name="setEnableKinematicVelocity")
    public void setEnableKinematicVelocity(boolean bl2) {
        this.enableKinematicVelocity = bl2;
    }

    @JvmName(name="getPersistentAttachedData")
    public final MutableClassToInstanceMap<Object> getPersistentAttachedData() {
        return this.persistentAttachedData;
    }

    @JvmName(name="getPortalCoolDown$impl")
    public final int getPortalCoolDown$impl() {
        return this.portalCoolDown;
    }

    @JvmName(name="setPortalCoolDown$impl")
    public final void setPortalCoolDown$impl(int n2) {
        this.portalCoolDown = n2;
    }

    @JvmName(name="getTransformProvider")
    public ServerShipTransformProvider getTransformProvider() {
        return this.transformProvider;
    }

    @JvmName(name="setTransformProvider")
    public void setTransformProvider(ServerShipTransformProvider serverShipTransformProvider) {
        this.transformProvider = serverShipTransformProvider;
    }

    @Override
    @JvmName(name="getShipToWorld")
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @Override
    @JvmName(name="getWorldToShip")
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, BlockType oldBlockType, BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"");
        super.onSetBlock(posX, posY, posZ, oldBlockType, newBlockType, oldBlockMass, newBlockMass, isRunningOnServer);
        this.getInertiaData().onSetBlockUseSphereMOI(posX, posY, posZ, oldBlockMass, newBlockMass);
        if (isRunningOnServer) {
            this.updateShipAABBGenerator(posX, posY, posZ, !Intrinsics.areEqual((Object)newBlockType, (Object)BlockTypeImpl.a.a()));
        }
    }

    @Override
    public void updateShipAABBGenerator(int posX, int posY, int posZ, boolean set) {
        if (set) {
            this.shipAABBGenerator.add(posX, posY, posZ);
        } else {
            this.shipAABBGenerator.remove(posX, posY, posZ);
        }
        AABBi aABBi = this.shipAABBGenerator.makeAABB();
        if (aABBi != null) {
            ++aABBi.maxX;
            ++aABBi.maxY;
            ++aABBi.maxZ;
        }
        this.setShipAABB((AABBic)aABBi);
    }

    @Override
    public void onLoadChunk(int chunkX, int chunkZ) {
        if (this.getChunkClaim().contains(chunkX, chunkZ)) {
            this.missingLoadedChunks.remove(chunkX, chunkZ);
        }
    }

    @Override
    public void onUnloadChunk(int chunkX, int chunkZ) {
        if (this.getChunkClaim().contains(chunkX, chunkZ) && this.getActiveChunksSet().contains(chunkX, chunkZ)) {
            this.missingLoadedChunks.add(chunkX, chunkZ);
        }
    }

    @Override
    public boolean areVoxelsFullyLoaded() {
        return this.missingLoadedChunks.getSize() == 0;
    }

    @Override
    public ShipDataCommon asShipDataCommon() {
        return this;
    }

    public <T> void saveAttachment(Class<T> clazz, T value) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        if (value instanceof zD && ((zD)value).a() == null) {
            ((zD)value).a(this);
        }
        if (value == null) {
            this.persistentAttachedData.remove(clazz);
        } else {
            ((Map)this.persistentAttachedData).put(clazz, value);
        }
    }

    public <T> T getAttachment(Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return (T)this.persistentAttachedData.getInstance(clazz);
    }

    private static final void _init_$lambda$0(ShipData this$0, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
        this$0.missingLoadedChunks.add(chunkX, chunkZ);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016JY\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\n\u001a\u00060\u0002j\u0002`\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipData$Companion;", "", "", "slug", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Lorg/joml/Vector3dc;", "shipCenterInWorldCoordinates", "shipCenterInShipCoordinates", "", "scaling", "", "isStatic", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "createEmpty", "(Ljava/lang/String;JLorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;DZ)Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public final ShipData createEmpty(String slug, long shipId, ChunkClaim chunkClaim, String chunkClaimDimension, Vector3dc shipCenterInWorldCoordinates, Vector3dc shipCenterInShipCoordinates, double scaling, boolean isStatic) {
            Intrinsics.checkNotNullParameter((Object)slug, (String)"");
            Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"");
            Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"");
            Intrinsics.checkNotNullParameter((Object)shipCenterInWorldCoordinates, (String)"");
            Intrinsics.checkNotNullParameter((Object)shipCenterInShipCoordinates, (String)"");
            Quaterniond quaterniond = new Quaterniond().fromAxisAngleDeg(0.0, 1.0, 0.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"");
            ShipTransform shipTransform = ShipTransformImpl.Companion.create(shipCenterInWorldCoordinates, shipCenterInShipCoordinates, (Quaterniondc)quaterniond, (Vector3dc)new Vector3d(scaling));
            return new ShipData(shipId, slug, chunkClaim, chunkClaimDimension, ShipPhysicsData.Companion.createEmpty(), ShipInertiaDataImpl.Companion.newEmptyShipInertiaData(), shipTransform, shipTransform, shipTransform.createEmptyAABB(), null, ShipActiveChunksSet.a.a(), isStatic, false, null, 0, 28672, null);
        }

        public static /* synthetic */ ShipData createEmpty$default(Companion companion, String string, long l2, ChunkClaim chunkClaim, String string2, Vector3dc vector3dc, Vector3dc vector3dc2, double d2, boolean bl2, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                d2 = 1.0;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = false;
            }
            return companion.createEmpty(string, l2, chunkClaim, string2, vector3dc, vector3dc2, d2, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

