/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.serialization.vspipeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.core.impl.game.ChunkAllocator;
import org.valkyrienskies.core.impl.game.c;
import org.valkyrienskies.core.impl.game.e;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.serialization.ChainUpdater;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.ServerShipDataConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV0;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV0Updater;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV1;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.VSPipelineDataConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineData;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineDataV1;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineDataV4;
import org.valkyrienskies.core.impl.shadow.At;
import org.valkyrienskies.core.impl.shadow.zN;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\b\u0007\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0006\u0010$\u001a\u00020#\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineSerializer;", "", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineData;", "pipelineData", "Lorg/valkyrienskies/core/impl/shadow/zN;", "asVsPipelineModule", "(Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineData;)Lorg/valkyrienskies/core/impl/shadow/zN;", "", "bytes", "deserialize", "([B)Lorg/valkyrienskies/core/impl/shadow/zN;", "queryableShipDataBytes", "chunkAllocatorBytes", "deserializeLegacy", "([B[B)Lorg/valkyrienskies/core/impl/shadow/zN;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV1;", "deserializeLegacyAsV1", "([B[B)Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV1;", "Lorg/valkyrienskies/core/impl/shadow/At;", "pipeline", "serialize", "(Lorg/valkyrienskies/core/impl/shadow/At;)[B", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;", "pipelineDataConverter", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;", "shipDataMapper", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV4;", "updater", "Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;", "v0Updater", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;)V"})
public final class VSPipelineSerializer {
    private final ObjectMapper objectMapper;
    private final ServerShipDataConverter shipDataMapper;
    private final ChainUpdater<VSPipelineDataV4> updater;
    private final ServerShipDataV0Updater v0Updater;
    private final VSPipelineDataConverter pipelineDataConverter;

    @Inject
    public VSPipelineSerializer(@Named(value="dto") ObjectMapper objectMapper, ServerShipDataConverter shipDataMapper, ChainUpdater<VSPipelineDataV4> updater, ServerShipDataV0Updater v0Updater, VSPipelineDataConverter pipelineDataConverter) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"");
        Intrinsics.checkNotNullParameter((Object)shipDataMapper, (String)"");
        Intrinsics.checkNotNullParameter(updater, (String)"");
        Intrinsics.checkNotNullParameter((Object)v0Updater, (String)"");
        Intrinsics.checkNotNullParameter((Object)pipelineDataConverter, (String)"");
        this.objectMapper = objectMapper;
        this.shipDataMapper = shipDataMapper;
        this.updater = updater;
        this.v0Updater = v0Updater;
        this.pipelineDataConverter = pipelineDataConverter;
    }

    public final zN deserializeLegacy(byte[] queryableShipDataBytes, byte[] chunkAllocatorBytes) {
        Intrinsics.checkNotNullParameter((Object)queryableShipDataBytes, (String)"");
        Intrinsics.checkNotNullParameter((Object)chunkAllocatorBytes, (String)"");
        return this.asVsPipelineModule(this.deserializeLegacyAsV1(queryableShipDataBytes, chunkAllocatorBytes));
    }

    public final zN deserialize(byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"");
        Object object = this.objectMapper;
        boolean bl2 = false;
        boolean bl3 = false;
        VSPipelineData vSPipelineData = (VSPipelineData)object.readValue(bytes, (TypeReference)new TypeReference<VSPipelineData>(){});
        object = this.updater.updateToLatest(vSPipelineData);
        return this.pipelineDataConverter.convertToModel((VSPipelineDataV4)object);
    }

    public final byte[] serialize(At pipeline) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"");
        Object object = (Iterable)pipeline.a().getAllShips();
        Object object2 = this.shipDataMapper;
        boolean bl2 = false;
        Iterable iterable = object;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        boolean bl3 = false;
        for (Object t2 : iterable) {
            ShipData shipData = (ShipData)t2;
            Collection collection2 = collection;
            boolean bl4 = false;
            collection2.add(object2.convertToDto(shipData));
        }
        List list = (List)collection;
        c c2 = pipeline.a().getChunkAllocators();
        Intrinsics.checkNotNull((Object)c2);
        object = ((e)c2).a();
        object2 = new VSPipelineDataV4((ChunkAllocator)object, list);
        byte[] byArray = this.objectMapper.writeValueAsBytes(object2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return byArray;
    }

    private final zN asVsPipelineModule(VSPipelineData pipelineData) {
        return this.pipelineDataConverter.convertToModel(this.updater.updateToLatest(pipelineData));
    }

    private final VSPipelineDataV1 deserializeLegacyAsV1(byte[] queryableShipDataBytes, byte[] chunkAllocatorBytes) {
        Object object = (ObjectMapper)VSJacksonUtil.INSTANCE.getDefaultMapper();
        boolean bl2 = false;
        boolean bl3 = false;
        List list = (List)object.readValue(queryableShipDataBytes, (TypeReference)new TypeReference<List<? extends ServerShipDataV0>>(){});
        Object object2 = (ObjectMapper)VSJacksonUtil.INSTANCE.getDefaultMapper();
        bl3 = false;
        boolean bl4 = false;
        object = (ChunkAllocator)object2.readValue(chunkAllocatorBytes, (TypeReference)new TypeReference<ChunkAllocator>(){});
        Iterable iterable = list;
        bl4 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl5 = false;
        for (Object t2 : iterable2) {
            ServerShipDataV0 serverShipDataV0 = (ServerShipDataV0)t2;
            Collection collection2 = collection;
            boolean bl6 = false;
            collection2.add((ServerShipDataV1)this.v0Updater.update(serverShipDataV0));
        }
        object2 = (List)collection;
        return new VSPipelineDataV1((ChunkAllocator)object, (List<ServerShipDataV1>)object2);
    }
}

