/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.entity.EntityAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ;\u0010\t\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0007\u00a2\u0006\u0004\b\t\u0010\u000eJ!\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0004\b\t\u0010\u0011J5\u0010\t\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0007\u00a2\u0006\u0004\b\t\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/mod/common/PlayerUtil;", "", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "blockInShip", "", "transformPlayerTemporarily", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "T", "Lkotlin/Function0;", "inside", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lorg/valkyrienskies/core/api/ships/LoadedShip;", "ship", "(Lnet/minecraft/world/entity/player/Player;Lorg/valkyrienskies/core/api/ships/LoadedShip;)V", "(Lnet/minecraft/world/entity/player/Player;Lorg/valkyrienskies/core/api/ships/LoadedShip;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "untransformPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/valkyrienskies/mod/common/PlayerUtil$TempPlayerPosInfo;", "prevPosInfo", "Ljava/util/concurrent/ConcurrentMap;", "<init>", "()V", "TempPlayerPosInfo", "valkyrienskies-120"})
public final class PlayerUtil {
    @NotNull
    public static final PlayerUtil INSTANCE = new PlayerUtil();
    @NotNull
    private static final ConcurrentMap<Player, TempPlayerPosInfo> prevPosInfo;

    private PlayerUtil() {
    }

    @JvmStatic
    public static final void transformPlayerTemporarily(@NotNull Player player, @NotNull Level world, @NotNull BlockPos blockInShip) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockInShip, (String)"blockInShip");
        PlayerUtil.transformPlayerTemporarily(player, VSGameUtilsKt.getShipObjectManagingPos(world, (Vec3i)blockInShip));
    }

    @JvmStatic
    public static final void transformPlayerTemporarily(@NotNull Player player, @Nullable LoadedShip ship) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        if (VSGameUtilsKt.isBlockInShipyard(level, player.m_20185_(), player.m_20186_(), player.m_20189_())) {
            return;
        }
        Map map = prevPosInfo;
        float f2 = player.m_146908_();
        float f3 = player.f_20885_;
        float f4 = player.m_146909_();
        Vec3 vec3 = player.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        TempPlayerPosInfo tempPlayerPosInfo = new TempPlayerPosInfo(f2, f3, f4, vec3);
        map.put(player, tempPlayerPosInfo);
        if (ship != null) {
            Matrix4dc shipMatrix = ship.getWorldToShip();
            Vec3 vec32 = player.m_20154_();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLookAngle(...)");
            Vector3d direction = shipMatrix.transformDirection(VectorConversionsMCKt.toJOML(vec32));
            Vec3 vec33 = player.m_20182_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
            Vector3d position = shipMatrix.transformPosition(VectorConversionsMCKt.toJOML(vec33));
            double yaw = -Math.atan2(direction.x, direction.z);
            double pitch = -Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
            player.m_146922_((float)(yaw * 57.29577951308232));
            player.f_20885_ = player.m_146908_();
            player.m_146926_((float)(pitch * 57.29577951308232));
            EntityAccessor entityAccessor = (EntityAccessor)player;
            Intrinsics.checkNotNull((Object)position);
            entityAccessor.setPosNoUpdates(VectorConversionsMCKt.toMinecraft((Vector3dc)position));
        }
    }

    @JvmStatic
    public static final void untransformPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TempPlayerPosInfo tempPlayerPosInfo = (TempPlayerPosInfo)prevPosInfo.remove(player);
        if (tempPlayerPosInfo == null) {
            return;
        }
        TempPlayerPosInfo info = tempPlayerPosInfo;
        player.m_146926_(info.getPitch());
        player.m_146922_(info.getYaw());
        player.f_20885_ = info.getHeadYaw();
        ((EntityAccessor)player).setPosNoUpdates(info.getPos());
    }

    @JvmStatic
    public static final <T> T transformPlayerTemporarily(@NotNull Player player, @NotNull Level world, @NotNull BlockPos blockInShip, @NotNull Function0<? extends T> inside) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockInShip, (String)"blockInShip");
        Intrinsics.checkNotNullParameter(inside, (String)"inside");
        return PlayerUtil.transformPlayerTemporarily(player, VSGameUtilsKt.getShipObjectManagingPos(world, (Vec3i)blockInShip), inside);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T transformPlayerTemporarily(@NotNull Player player, @Nullable LoadedShip ship, @NotNull Function0<? extends T> inside) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(inside, (String)"inside");
        PlayerUtil.transformPlayerTemporarily(player, ship);
        try {
            Object object = inside.invoke();
            return (T)object;
        }
        finally {
            PlayerUtil.untransformPlayer(player);
        }
    }

    static {
        ConcurrentMap concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        prevPosInfo = concurrentMap;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001b\u0010\u0004R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001a\u001a\u0004\b\u001c\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b\u001e\u0010\tR\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001f\u0010\u0004\u00a8\u0006\""}, d2={"Lorg/valkyrienskies/mod/common/PlayerUtil$TempPlayerPosInfo;", "", "", "component1", "()F", "component2", "component3", "Lnet/minecraft/world/phys/Vec3;", "component4", "()Lnet/minecraft/world/phys/Vec3;", "yaw", "headYaw", "pitch", "pos", "copy", "(FFFLnet/minecraft/world/phys/Vec3;)Lorg/valkyrienskies/mod/common/PlayerUtil$TempPlayerPosInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getHeadYaw", "getPitch", "Lnet/minecraft/world/phys/Vec3;", "getPos", "getYaw", "<init>", "(FFFLnet/minecraft/world/phys/Vec3;)V", "valkyrienskies-120"})
    private static final class TempPlayerPosInfo {
        private final float yaw;
        private final float headYaw;
        private final float pitch;
        @NotNull
        private final Vec3 pos;

        public TempPlayerPosInfo(float yaw, float headYaw, float pitch, @NotNull Vec3 pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.yaw = yaw;
            this.headYaw = headYaw;
            this.pitch = pitch;
            this.pos = pos;
        }

        public final float getYaw() {
            return this.yaw;
        }

        public final float getHeadYaw() {
            return this.headYaw;
        }

        public final float getPitch() {
            return this.pitch;
        }

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        public final float component1() {
            return this.yaw;
        }

        public final float component2() {
            return this.headYaw;
        }

        public final float component3() {
            return this.pitch;
        }

        @NotNull
        public final Vec3 component4() {
            return this.pos;
        }

        @NotNull
        public final TempPlayerPosInfo copy(float yaw, float headYaw, float pitch, @NotNull Vec3 pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new TempPlayerPosInfo(yaw, headYaw, pitch, pos);
        }

        public static /* synthetic */ TempPlayerPosInfo copy$default(TempPlayerPosInfo tempPlayerPosInfo, float f2, float f3, float f4, Vec3 vec3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f2 = tempPlayerPosInfo.yaw;
            }
            if ((n2 & 2) != 0) {
                f3 = tempPlayerPosInfo.headYaw;
            }
            if ((n2 & 4) != 0) {
                f4 = tempPlayerPosInfo.pitch;
            }
            if ((n2 & 8) != 0) {
                vec3 = tempPlayerPosInfo.pos;
            }
            return tempPlayerPosInfo.copy(f2, f3, f4, vec3);
        }

        @NotNull
        public String toString() {
            return "TempPlayerPosInfo(yaw=" + this.yaw + ", headYaw=" + this.headYaw + ", pitch=" + this.pitch + ", pos=" + this.pos + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.yaw);
            result = result * 31 + Float.hashCode(this.headYaw);
            result = result * 31 + Float.hashCode(this.pitch);
            result = result * 31 + this.pos.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempPlayerPosInfo)) {
                return false;
            }
            TempPlayerPosInfo tempPlayerPosInfo = (TempPlayerPosInfo)other;
            if (Float.compare(this.yaw, tempPlayerPosInfo.yaw) != 0) {
                return false;
            }
            if (Float.compare(this.headYaw, tempPlayerPosInfo.headYaw) != 0) {
                return false;
            }
            if (Float.compare(this.pitch, tempPlayerPosInfo.pitch) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pos, (Object)tempPlayerPosInfo.pos);
        }
    }
}

