/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityData;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityServer;
import org.valkyrienskies.core.apigame.physics.VSSphereCollisionShapeData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.ShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.phys_entities.PhysicsEntityClient;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.entity.EntityAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 I2\u00020\u0001:\u0001IB\u001d\u0012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00000C\u0012\u0006\u0010F\u001a\u00020E\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011JG\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0006J\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010\u0006J7\u0010!\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b#\u0010\u0006J\u0017\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0019\u0010+\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010/\u001a\u00020\u00042\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b1\u00102J\u000f\u00103\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b3\u0010\bJ\u000f\u00104\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b4\u0010\bR\u0018\u00106\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R(\u0010.\u001a\u0004\u0018\u00010-2\b\u0010:\u001a\u0004\u0018\u00010-8\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\b.\u0010;\u001a\u0004\b<\u0010=R(\u0010?\u001a\u0004\u0018\u00010>2\b\u0010:\u001a\u0004\u0018\u00010>8\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\u00a8\u0006J"}, d2={"Lorg/valkyrienskies/mod/common/entity/VSPhysicsEntity;", "Lnet/minecraft/world/entity/Entity;", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "defineSynchedData", "()V", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getAddEntityPacket", "()Lnet/minecraft/network/protocol/Packet;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "shipObjectClientWorld", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getRenderTransform", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "", "d", "e", "f", "", "g", "h", "", "i", "", "bl", "lerpTo", "(DDDFFIZ)V", "load", "loadForTeleport", "moveTo", "(DDDFF)V", "readAdditionalSaveData", "entity", "restoreFrom", "(Lnet/minecraft/world/entity/Entity;)V", "saveWithoutId", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/world/level/entity/EntityInLevelCallback;", "callback", "setLevelCallback", "(Lnet/minecraft/world/level/entity/EntityInLevelCallback;)V", "Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;", "physicsEntityData", "setPhysicsEntityData", "(Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;)V", "shouldRenderAtSqrDistance", "(D)Z", "tick", "tickLerp", "Lorg/joml/Vector3dc;", "lerpPos", "Lorg/joml/Vector3dc;", "lerpSteps", "I", "<set-?>", "Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;", "getPhysicsEntityData", "()Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;", "Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityServer;", "physicsEntityServer", "Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityServer;", "getPhysicsEntityServer", "()Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityServer;", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Companion", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nVSPhysicsEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSPhysicsEntity.kt\norg/valkyrienskies/mod/common/entity/VSPhysicsEntity\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,252:1\n53#2:253\n43#2:254\n53#2:255\n43#2:256\n*S KotlinDebug\n*F\n+ 1 VSPhysicsEntity.kt\norg/valkyrienskies/mod/common/entity/VSPhysicsEntity\n*L\n144#1:253\n144#1:254\n157#1:255\n157#1:256\n*E\n"})
public class VSPhysicsEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PhysicsEntityData physicsEntityData;
    @Nullable
    private PhysicsEntityServer physicsEntityServer;
    @Nullable
    private Vector3dc lerpPos;
    private int lerpSteps;
    @NotNull
    private static final String PHYS_DATA_NBT_KEY = "phys_entity_data";
    private static final int CLIENT_INTERP_STEPS = 3;
    @NotNull
    private static final EntityDataAccessor<String> SHIP_ID_DATA;

    public VSPhysicsEntity(@NotNull EntityType<VSPhysicsEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    @Nullable
    protected final PhysicsEntityData getPhysicsEntityData() {
        return this.physicsEntityData;
    }

    @Nullable
    protected final PhysicsEntityServer getPhysicsEntityServer() {
        return this.physicsEntityServer;
    }

    public final void setPhysicsEntityData(@NotNull PhysicsEntityData physicsEntityData) {
        Intrinsics.checkNotNullParameter((Object)physicsEntityData, (String)"physicsEntityData");
        if (this.physicsEntityData != null) {
            throw new IllegalStateException("Cannot define physicsEntityData, its already defined!");
        }
        this.physicsEntityData = physicsEntityData;
        if (!this.m_9236_().f_46443_) {
            Rotations defaultRot = new Rotations(0.0f, 0.0f, 0.0f);
            if (!this.m_9236_().f_46443_) {
                Vector3d eulerAngles = physicsEntityData.getTransform().getShipToWorldRotation().getEulerAnglesXYZ(new Vector3d());
                defaultRot = new Rotations((float)eulerAngles.x, (float)eulerAngles.y, (float)eulerAngles.z);
            }
            this.f_19804_.m_135381_(SHIP_ID_DATA, (Object)String.valueOf(physicsEntityData.getShipId()));
        }
    }

    public void m_8119_() {
        if (this.lerpPos == null) {
            Vec3 vec3 = this.m_20182_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            this.lerpPos = (Vector3dc)VectorConversionsMCKt.toJOML(vec3);
        }
        if (!this.m_9236_().f_46443_) {
            PhysicsEntityServer physicsEntityServerCopy = this.physicsEntityServer;
            if (physicsEntityServerCopy != null) {
                ShipTransform transform = physicsEntityServerCopy.getShipTransform();
                this.m_146884_(VectorConversionsMCKt.toMinecraft(transform.getPositionInWorld()));
                Vector3d eulerAngles = transform.getShipToWorldRotation().getEulerAnglesXYZ(new Vector3d());
                PhysicsEntityData physicsEntityData = this.physicsEntityData;
                Intrinsics.checkNotNull((Object)physicsEntityData);
                physicsEntityData.setTransform(transform);
            }
            this.m_146872_();
        } else {
            this.tickLerp();
        }
        super.m_8119_();
    }

    public void m_6453_(double d2, double e2, double f2, float g2, float h2, int i2, boolean bl2) {
        this.lerpPos = (Vector3dc)new Vector3d(d2, e2, f2);
        this.lerpSteps = 3;
    }

    private final void tickLerp() {
        if (this.lerpSteps <= 0) {
            return;
        }
        if (this.lerpSteps == 1) {
            Vector3dc vector3dc = this.lerpPos;
            Intrinsics.checkNotNull((Object)vector3dc);
            double d2 = vector3dc.x();
            Vector3dc vector3dc2 = this.lerpPos;
            Intrinsics.checkNotNull((Object)vector3dc2);
            double d3 = vector3dc2.y();
            Vector3dc vector3dc3 = this.lerpPos;
            Intrinsics.checkNotNull((Object)vector3dc3);
            this.m_6034_(d2, d3, vector3dc3.z());
            this.lerpSteps = 0;
            return;
        }
        double d4 = this.m_20185_();
        Vector3dc vector3dc = this.lerpPos;
        Intrinsics.checkNotNull((Object)vector3dc);
        double d5 = d4 + (vector3dc.x() - this.m_20185_()) / (double)this.lerpSteps;
        double d6 = this.m_20186_();
        Vector3dc vector3dc4 = this.lerpPos;
        Intrinsics.checkNotNull((Object)vector3dc4);
        double e2 = d6 + (vector3dc4.y() - this.m_20186_()) / (double)this.lerpSteps;
        double d7 = this.m_20189_();
        Vector3dc vector3dc5 = this.lerpPos;
        Intrinsics.checkNotNull((Object)vector3dc5);
        double f2 = d7 + (vector3dc5.z() - this.m_20189_()) / (double)this.lerpSteps;
        this.lerpSteps += -1;
        this.m_6034_(d5, e2, f2);
    }

    @Nullable
    public final ShipTransform getRenderTransform(@NotNull ShipObjectClientWorld shipObjectClientWorld) {
        PhysicsEntityClient physEntityClient;
        Intrinsics.checkNotNullParameter((Object)shipObjectClientWorld, (String)"shipObjectClientWorld");
        String shipIdString = (String)this.f_19804_.m_135370_(SHIP_ID_DATA);
        if (Intrinsics.areEqual((Object)shipIdString, (Object)"")) {
            return null;
        }
        Intrinsics.checkNotNull((Object)shipIdString);
        long shipIdLong = Long.parseLong(shipIdString);
        PhysicsEntityClient physicsEntityClient = physEntityClient = shipObjectClientWorld.getPhysicsEntities().get(shipIdLong);
        return physicsEntityClient != null ? physicsEntityClient.getRenderTransform() : null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SHIP_ID_DATA, (Object)"");
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return (Packet)new ClientboundAddEntityPacket((Entity)this);
    }

    @NotNull
    public CompoundTag m_20240_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        byte[] physicsEntityDataAsBytes = VSPhysicsEntity.Companion.getMapper().writeValueAsBytes((Object)this.physicsEntityData);
        compoundTag.m_128382_(PHYS_DATA_NBT_KEY, physicsEntityDataAsBytes);
        CompoundTag compoundTag2 = super.m_20240_(compoundTag);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"saveWithoutId(...)");
        return compoundTag2;
    }

    private final void loadForTeleport(CompoundTag compoundTag) {
        if (!this.m_9236_().f_46443_ && this.physicsEntityData != null) {
            throw new IllegalStateException("This entity is already loaded!");
        }
        byte[] byArray = compoundTag.m_128463_(PHYS_DATA_NBT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByteArray(...)");
        byte[] physicsEntityDataAsBytes = byArray;
        ObjectMapper $this$readValue$iv = VSPhysicsEntity.Companion.getMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        PhysicsEntityData oldPhysicsEntityData = (PhysicsEntityData)$this$readValue$iv.readValue(physicsEntityDataAsBytes, (TypeReference)new TypeReference<PhysicsEntityData>(){});
        ShipWorldCore shipWorldCore = VSGameUtilsKt.getShipObjectWorld(this.m_9236_());
        Intrinsics.checkNotNull((Object)shipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld");
        ShipObjectServerWorld shipObjectServerWorld = (ShipObjectServerWorld)shipWorldCore;
        Level level = this.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        long newShipId = shipObjectServerWorld.allocateShipId(VSGameUtilsKt.getDimensionId(level));
        PhysicsEntityData newPhysicsEntityData = oldPhysicsEntityData.copyPhysicsEntityDataWithNewId(newShipId);
        this.setPhysicsEntityData(newPhysicsEntityData);
        super.m_20258_(compoundTag);
    }

    public void m_20258_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        if (!this.m_9236_().f_46443_ && this.physicsEntityData != null) {
            throw new IllegalStateException("This entity is already loaded!");
        }
        byte[] byArray = compoundTag.m_128463_(PHYS_DATA_NBT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByteArray(...)");
        byte[] physicsEntityDataAsBytes = byArray;
        ObjectMapper $this$readValue$iv = VSPhysicsEntity.Companion.getMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        PhysicsEntityData physicsEntityData = (PhysicsEntityData)$this$readValue$iv.readValue(physicsEntityDataAsBytes, (TypeReference)new TypeReference<PhysicsEntityData>(){});
        this.setPhysicsEntityData(physicsEntityData);
        super.m_20258_(compoundTag);
    }

    public void m_141960_(@Nullable EntityInLevelCallback callback) {
        super.m_141960_(callback);
        if (!this.m_9236_().f_46443_) {
            boolean isNull;
            boolean bl2 = isNull = callback == null || Intrinsics.areEqual((Object)callback, (Object)EntityInLevelCallback.f_156799_);
            if (!isNull) {
                if (this.physicsEntityServer != null) {
                    throw new IllegalStateException("Rigid body is already in the world!");
                }
                ShipWorldCore shipWorldCore = VSGameUtilsKt.getShipObjectWorld(this.m_9236_());
                Intrinsics.checkNotNull((Object)shipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.world.ServerShipWorldCore");
                ServerShipWorldCore serverShipWorldCore = (ServerShipWorldCore)shipWorldCore;
                PhysicsEntityData physicsEntityData = this.physicsEntityData;
                Intrinsics.checkNotNull((Object)physicsEntityData);
                Level level = this.m_9236_();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                this.physicsEntityServer = serverShipWorldCore.createPhysicsEntity(physicsEntityData, VSGameUtilsKt.getDimensionId(level));
            } else {
                if (this.physicsEntityServer == null) {
                    return;
                }
                ShipWorldCore shipWorldCore = VSGameUtilsKt.getShipObjectWorld(this.m_9236_());
                Intrinsics.checkNotNull((Object)shipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.world.ServerShipWorldCore");
                ServerShipWorldCore serverShipWorldCore = (ServerShipWorldCore)shipWorldCore;
                PhysicsEntityData physicsEntityData = this.physicsEntityData;
                Intrinsics.checkNotNull((Object)physicsEntityData);
                serverShipWorldCore.deletePhysicsEntity(physicsEntityData.getShipId());
                this.physicsEntityServer = null;
            }
        }
    }

    public boolean m_6783_(double d2) {
        double e2 = this.m_20191_().m_82309_();
        if (Double.isNaN(e2)) {
            e2 = 1.0;
        }
        return d2 < (e2 *= 1024.0) * e2;
    }

    public void m_7678_(double d2, double e2, double f2, float g2, float h2) {
        super.m_7678_(d2, e2, f2, g2, h2);
        if (!this.m_9236_().f_46443_) {
            PhysicsEntityServer physicsEntityServerCopy = this.physicsEntityServer;
            if (physicsEntityServerCopy != null) {
                Vector3d newPos = new Vector3d(d2, e2, f2);
                ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl((Vector3dc)newPos, null, null, null, null, null, 62, null);
                ShipWorldCore shipWorldCore = VSGameUtilsKt.getShipObjectWorld(this.m_9236_());
                Intrinsics.checkNotNull((Object)shipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld");
                ShipObjectServerWorld shipObjectServerWorld = (ShipObjectServerWorld)shipWorldCore;
                PhysicsEntityServer physicsEntityServer = this.physicsEntityServer;
                Intrinsics.checkNotNull((Object)physicsEntityServer);
                shipObjectServerWorld.teleportPhysicsEntity(physicsEntityServer, teleportData);
            } else {
                PhysicsEntityData physicsEntityData = this.physicsEntityData;
                Intrinsics.checkNotNull((Object)physicsEntityData);
                Vector3dc vector3dc = (Vector3dc)new Vector3d(d2, e2, f2);
                Vector3dc vector3dc2 = (Vector3dc)new Vector3d();
                PhysicsEntityData physicsEntityData2 = this.physicsEntityData;
                Intrinsics.checkNotNull((Object)physicsEntityData2);
                physicsEntityData.setTransform(ShipTransformImpl.Companion.create(vector3dc, vector3dc2, physicsEntityData2.getTransform().getShipToWorldRotation()));
            }
        }
    }

    public void m_20361_(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        CompoundTag compoundTag = entity.m_20240_(new CompoundTag());
        compoundTag.m_128473_("Dimension");
        Intrinsics.checkNotNull((Object)compoundTag);
        this.loadForTeleport(compoundTag);
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type org.valkyrienskies.mod.mixin.accessors.entity.EntityAccessor");
        ((EntityAccessor)((Object)this)).setPortalCooldown(((EntityAccessor)entity).getPortalCooldown());
        this.f_19819_ = ((EntityAccessor)entity).getPortalEntrancePos();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(VSPhysicsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        SHIP_ID_DATA = entityDataAccessor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ5\u0010\u000b\u001a\u00020\n2\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/mod/common/entity/VSPhysicsEntity$Companion;", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "transform", "", "radius", "mass", "Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;", "createBasicSphereData", "(JLorg/valkyrienskies/core/api/ships/properties/ShipTransform;DD)Lorg/valkyrienskies/core/apigame/physics/PhysicsEntityData;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "", "CLIENT_INTERP_STEPS", "I", "", "PHYS_DATA_NBT_KEY", "Ljava/lang/String;", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "SHIP_ID_DATA", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "<init>", "()V", "valkyrienskies-120"})
    public static final class Companion {
        private Companion() {
        }

        private final ObjectMapper getMapper() {
            return (ObjectMapper)VSJacksonUtil.INSTANCE.getDefaultMapper();
        }

        @NotNull
        public final PhysicsEntityData createBasicSphereData(long shipId, @NotNull ShipTransform transform, double radius, double mass) {
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            double inertia = 0.4 * mass * radius * radius;
            Vector3d vector3d = new Vector3d();
            Matrix3d matrix3d = new Matrix3d().scale(inertia);
            Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"scale(...)");
            ShipInertiaData inertiaData = new ShipInertiaDataImpl(vector3d, mass, matrix3d);
            VSSphereCollisionShapeData collisionShapeData = new VSSphereCollisionShapeData(radius);
            return new PhysicsEntityData(shipId, transform, inertiaData, (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), collisionShapeData, 0, 0.0, 0.0, 0.0, false, 960, null);
        }

        public static /* synthetic */ PhysicsEntityData createBasicSphereData$default(Companion companion, long l2, ShipTransform shipTransform, double d2, double d3, int n2, Object object) {
            if ((n2 & 4) != 0) {
                d2 = 0.5;
            }
            if ((n2 & 8) != 0) {
                d3 = 10000.0;
            }
            return companion.createBasicSphereData(l2, shipTransform, d2, d3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

