/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.explosions;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.GameTickForceApplier;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={Explosion.class})
public abstract class MixinExplosion {
    @Shadow
    @Final
    private Level f_46012_;
    @Shadow
    @Final
    @Mutable
    private double f_46013_;
    @Shadow
    @Final
    @Mutable
    private double f_46014_;
    @Shadow
    @Final
    @Mutable
    private double f_46015_;
    @Shadow
    @Final
    @Mutable
    private float f_46017_;
    @Unique
    private boolean isModifyingExplosion = false;

    @Shadow
    public abstract void m_46061_();

    @Unique
    private void doExplodeForce() {
        int radius;
        Vector3d originPos = new Vector3d(this.f_46013_, this.f_46014_, this.f_46015_);
        BlockPos explodePos = BlockPos.m_274561_((double)originPos.x(), (double)originPos.y(), (double)originPos.z());
        for (int x2 = radius = (int)Math.ceil(this.f_46017_); x2 >= -radius; --x2) {
            for (int y2 = radius; y2 >= -radius; --y2) {
                for (int z2 = radius; z2 >= -radius; --z2) {
                    BlockPos blockPos;
                    ServerShip ship;
                    BlockHitResult result = this.f_46012_.m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)explodePos), Vec3.m_82512_((Vec3i)explodePos.m_7918_(x2, y2, z2)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                    if (result.m_6662_() != HitResult.Type.BLOCK || (ship = (ServerShip)VSGameUtilsKt.getShipObjectManagingPos(this.f_46012_, (Vec3i)(blockPos = result.m_82425_()))) == null) continue;
                    Vector3d forceVector = VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)explodePos));
                    Double distanceMult = Math.max(0.5, 1.0 - (double)this.f_46017_ / forceVector.distance((Vector3dc)VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)blockPos))));
                    Double powerMult = Math.max(0.1, (double)(this.f_46017_ / 4.0f));
                    forceVector.sub((Vector3dc)VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)blockPos)));
                    forceVector.normalize();
                    forceVector.mul(-1.0 * VSGameConfig.SERVER.getExplosionBlastForce());
                    forceVector.mul(distanceMult.doubleValue());
                    forceVector.mul(powerMult.doubleValue());
                    GameTickForceApplier forceApplier = (GameTickForceApplier)ship.getAttachment(GameTickForceApplier.class);
                    Vector3dc shipCoords = ship.getShipTransform().getShipPositionInShipCoordinates();
                    if (!forceVector.isFinite()) continue;
                    forceApplier.applyInvariantForceToPos((Vector3dc)forceVector, (Vector3dc)VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)blockPos)).sub(shipCoords));
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"explode"})
    private void afterExplode(CallbackInfo ci2) {
        if (this.isModifyingExplosion) {
            this.doExplodeForce();
            return;
        }
        this.isModifyingExplosion = true;
        double origX = this.f_46013_;
        double origY = this.f_46014_;
        double origZ = this.f_46015_;
        VSGameUtilsKt.transformToNearbyShipsAndWorld(this.f_46012_, this.f_46013_, this.f_46014_, this.f_46015_, (double)this.f_46017_, (x2, y2, z2) -> {
            this.f_46013_ = x2;
            this.f_46014_ = y2;
            this.f_46015_ = z2;
            this.m_46061_();
        });
        this.f_46013_ = origX;
        this.f_46014_ = origY;
        this.f_46015_ = origZ;
        this.isModifyingExplosion = false;
    }

    @WrapOperation(method={"explode"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private List<Entity> noRayTrace(Level instance, Entity entity, AABB aabb, Operation<List<Entity>> getEntities) {
        if (this.isModifyingExplosion) {
            return Collections.emptyList();
        }
        return (List)getEntities.call(new Object[]{instance, entity, aabb});
    }
}

