/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.world.chunk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.util.VSLevelChunk;

@Mixin(value={LevelChunk.class})
public abstract class MixinLevelChunk
extends ChunkAccess
implements VSLevelChunk {
    @Shadow
    @Final
    Level f_62776_;
    @Shadow
    @Mutable
    private LevelChunkTicks<Block> f_62784_;
    @Shadow
    @Mutable
    private LevelChunkTicks<Fluid> f_187943_;
    @Unique
    private static final Set<Heightmap.Types> ALL_HEIGHT_MAP_TYPES = new HashSet<Heightmap.Types>(Arrays.asList(Heightmap.Types.values()));

    public MixinLevelChunk(Ship ship) {
        super(null, null, null, null, 0L, null, null);
        throw new IllegalStateException("This should never be called!");
    }

    @Inject(method={"setBlockState"}, at={@At(value="TAIL")})
    public void postSetBlockState(BlockPos pos, BlockState state, boolean moved, CallbackInfoReturnable<BlockState> cir) {
        BlockState prevState = (BlockState)cir.getReturnValue();
        BlockStateInfo.INSTANCE.onSetBlock(this.f_62776_, pos, prevState, state);
    }

    @Shadow
    public abstract void m_187957_();

    @Shadow
    public abstract void m_187958_(ServerLevel var1);

    @Shadow
    public abstract void m_187979_(ServerLevel var1);

    @Override
    public void clearChunk() {
        this.m_187957_();
        this.m_187979_((ServerLevel)this.f_62776_);
        this.f_187608_.clear();
        Arrays.fill(this.f_187612_, null);
        Registry registry = this.f_62776_.m_9598_().m_175515_(Registries.f_256952_);
        for (int i2 = 0; i2 < this.f_187612_.length; ++i2) {
            if (this.f_187612_[i2] != null) continue;
            this.f_187612_[i2] = new LevelChunkSection(registry);
        }
        this.m_8094_(false);
        this.m_187958_((ServerLevel)this.f_62776_);
        this.f_187603_ = true;
    }

    @Override
    public void copyChunkFromOtherDimension(@NotNull VSLevelChunk srcChunkVS) {
        this.m_187957_();
        this.m_187979_((ServerLevel)this.f_62776_);
        this.f_187608_.clear();
        Arrays.fill(this.f_187612_, null);
        LevelChunk srcChunk = (LevelChunk)srcChunkVS;
        CompoundTag compoundTag = ChunkSerializer.m_63454_((ServerLevel)((ServerLevel)srcChunk.m_62953_()), (ChunkAccess)srcChunk);
        compoundTag.m_128359_("Status", ChunkStatus.ChunkType.PROTOCHUNK.name());
        ProtoChunk protoChunk = ChunkSerializer.m_188230_((ServerLevel)((ServerLevel)this.f_62776_), (PoiManager)((ServerLevel)this.f_62776_).m_8904_(), (ChunkPos)this.f_187604_, (CompoundTag)compoundTag);
        this.f_62784_ = protoChunk.m_188181_();
        this.f_187943_ = protoChunk.m_188182_();
        for (int i2 = 0; i2 < this.f_187612_.length; ++i2) {
            this.f_187612_[i2] = protoChunk.m_183278_(i2);
        }
        Registry registry = this.f_62776_.m_9598_().m_175515_(Registries.f_256952_);
        for (int i3 = 0; i3 < this.f_187612_.length; ++i3) {
            if (this.f_187612_[i3] != null) continue;
            this.f_187612_[i3] = new LevelChunkSection(registry);
        }
        this.f_187607_ = protoChunk.m_183407_();
        for (BlockEntity blockEntity : protoChunk.m_63292_().values()) {
            this.m_142169_(blockEntity);
        }
        this.f_187609_.putAll(protoChunk.m_63294_());
        for (int i4 = 0; i4 < protoChunk.m_6720_().length; ++i4) {
            this.f_187602_[i4] = protoChunk.m_6720_()[i4];
        }
        this.m_8040_(protoChunk.m_6633_());
        this.m_62737_(protoChunk.m_62769_());
        Heightmap.m_64256_((ChunkAccess)this, ALL_HEIGHT_MAP_TYPES);
        this.m_8094_(false);
        this.m_187958_((ServerLevel)this.f_62776_);
        this.f_187603_ = true;
    }
}

