/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.world.level.levelgen;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VS2ChunkAllocator;

@Mixin(value={NoiseBasedChunkGenerator.class})
public class MixinNoiseBasedChunkGenerator {
    @Shadow
    @Final
    protected Holder<NoiseGeneratorSettings> f_64318_;

    @Inject(method={"getBaseColumn"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetBaseColumn(int i2, int j2, LevelHeightAccessor levelHeightAccessor, RandomState randomState, CallbackInfoReturnable<NoiseColumn> cir) {
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(i2, j2)) {
            NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_64439_();
            int k2 = Math.max(noiseSettings.f_158688_(), levelHeightAccessor.m_141937_());
            cir.setReturnValue((Object)new NoiseColumn(k2, new BlockState[0]));
        }
    }

    @Inject(method={"buildSurface(Lnet/minecraft/server/level/WorldGenRegion;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/chunk/ChunkAccess;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preBuildSurface(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, CallbackInfo ci2) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"applyCarvers"}, at={@At(value="HEAD")}, cancellable=true)
    private void preApplyCarvers(WorldGenRegion worldGenRegion, long l2, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving, CallbackInfo ci2) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"fillFromNoise"}, at={@At(value="HEAD")}, cancellable=true)
    private void preFillFromNoise(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess, CallbackInfoReturnable<CompletableFuture<ChunkAccess>> cir) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            cir.setReturnValue(CompletableFuture.completedFuture(chunkAccess));
        }
    }

    @Inject(method={"spawnOriginalMobs"}, at={@At(value="HEAD")}, cancellable=true)
    private void preSpawnOriginalMobs(WorldGenRegion worldGenRegion, CallbackInfo ci2) {
        ChunkPos chunkPos = worldGenRegion.m_143488_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }
}

