/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import org.valkyrienskies.physics_api.ShapeInUseException;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.WheelShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;

class KrunchNativeWheelShapeReference
implements WheelShapeReference,
KrunchShapeReference {
    private long shapeAddress;
    private static final long DELETED_SHAPE_ADDRESS = -1L;

    protected KrunchNativeWheelShapeReference(long shapeAddress) {
        this.shapeAddress = shapeAddress;
    }

    @Override
    public void close() {
        this.ensureNotDeleted();
        boolean deleteSuccessful = KrunchNativeWheelShapeReference.deleteWheelShape(this.shapeAddress);
        if (!deleteSuccessful) {
            throw new ShapeInUseException("Delete box shape failed! This shape is currently in use!");
        }
        this.shapeAddress = -1L;
    }

    protected void finalize() {
        if (this.shapeAddress != -1L) {
            this.close();
        }
    }

    @Override
    public long getShapeShapeAddress() {
        this.ensureNotDeleted();
        return this.shapeAddress;
    }

    @Override
    public double getHalfThickness() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        double[] lengths = new double[1];
        boolean success = KrunchNativeWheelShapeReference.getHalfThickness(this.shapeAddress, lengths);
        if (!success) {
            throw new IllegalStateException("Call to getHalfThickness() failed");
        }
        return lengths[0];
    }

    @Override
    public void setHalfThickness(double halfThickness) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        if (!KrunchNativeWheelShapeReference.setHalfThickness(this.shapeAddress, halfThickness)) {
            throw new IllegalStateException("Call to setHalfThickness() failed");
        }
    }

    @Override
    public double getWheelRadius() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        double[] wheelRadius = new double[1];
        boolean success = KrunchNativeWheelShapeReference.getWheelRadius(this.shapeAddress, wheelRadius);
        if (!success) {
            throw new IllegalStateException("Call to getLengths() failed");
        }
        return wheelRadius[0];
    }

    @Override
    public void setWheelRadius(double wheelRadius) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        if (!KrunchNativeWheelShapeReference.setWheelRadius(this.shapeAddress, wheelRadius)) {
            throw new IllegalStateException("Call to setWheelRadius() failed");
        }
    }

    @Override
    public int getPointShellSize() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        int[] pointShellSize = new int[1];
        boolean success = KrunchNativeWheelShapeReference.getPointShellSize(this.shapeAddress, pointShellSize);
        if (!success) {
            throw new IllegalStateException("Call to getPointShellSize() failed");
        }
        return pointShellSize[0];
    }

    @Override
    public void setPointShellSize(int pointShellSize) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        if (!KrunchNativeWheelShapeReference.setPointShellSize(this.shapeAddress, pointShellSize)) {
            throw new IllegalStateException("Call to setPointShellSize() failed");
        }
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.shapeAddress == -1L;
    }

    private void ensureNotDeleted() {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native boolean getHalfThickness(long var0, double[] var2);

    private static native boolean setHalfThickness(long var0, double var2);

    private static native boolean getWheelRadius(long var0, double[] var2);

    private static native boolean setWheelRadius(long var0, double var2);

    private static native boolean getPointShellSize(long var0, int[] var2);

    private static native boolean setPointShellSize(long var0, int var2);

    private static native boolean deleteWheelShape(long var0);
}

