/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.image;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.watermedia.WaterMedia;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageFetch;
import org.watermedia.api.image.ImageRenderer;

public class ImageCache {
    static final Map<URI, ImageCache> CACHE = new HashMap<URI, ImageCache>();
    public final URI uri;
    private final ImageFetch fetch;
    private final Executor renderThreadEx;
    private final AtomicInteger uses = new AtomicInteger(1);
    private volatile Status status = Status.WAITING;
    private volatile boolean video = false;
    private volatile boolean cache = false;
    private volatile ImageRenderer renderer;
    private volatile Exception exception;
    private final List<Consumer<ImageRenderer>> releaseListeners = new ArrayList<Consumer<ImageRenderer>>();

    ImageCache(URI uri, Executor runnable) {
        this.uri = uri;
        this.renderThreadEx = runnable;
        this.fetch = new ImageFetch(uri);
        CACHE.put(uri, this);
    }

    ImageCache(ImageRenderer renderer) {
        this.uri = URI.create("water://media/");
        this.fetch = null;
        this.renderThreadEx = null;
        this.renderer = renderer;
    }

    public boolean isCache() {
        return this.cache;
    }

    public boolean isVideo() {
        return this.video;
    }

    public boolean isUsed() {
        return this.uses.get() > 0;
    }

    public ImageCache use() {
        this.uses.incrementAndGet();
        return this;
    }

    public ImageCache deuse() {
        if (this.uses.decrementAndGet() <= 0) {
            this.release();
        }
        return this;
    }

    public ImageCache flush() {
        if (this.uses.get() == 1 && this.renderer != null && !this.renderer.isFlushed()) {
            this.renderer.flush();
        }
        return this;
    }

    public ImageCache reset() {
        if (this.uses.get() == 1 && this.renderer != null && this.renderer.isFlushed()) {
            this.renderer.reset();
        }
        return this;
    }

    public int getUsages() {
        return this.uses.get();
    }

    public Status getStatus() {
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public ImageRenderer getRenderer() {
        if (this.isVideo()) {
            return ImageAPI.failedVLC();
        }
        return this.renderer;
    }

    public ImageCache addReleaseCallback(Consumer<ImageRenderer> consumer) {
        this.releaseListeners.add(consumer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (!this.status.equals((Object)Status.WAITING)) {
                return;
            }
            this.status = Status.LOADING;
            this.fetch.setSuccessCallback((imageRenderer, isCache) -> {
                ImageFetch imageFetch = this.fetch;
                synchronized (imageFetch) {
                    if (!this.status.equals((Object)Status.LOADING)) {
                        this.renderThreadEx.execute(imageRenderer::release);
                        return;
                    }
                    this.renderer = imageRenderer;
                    this.cache = isCache;
                    this.video = false;
                    this.exception = null;
                    this.status = Status.READY;
                }
            }).setErrorCallback((exception, isVideo) -> {
                ImageFetch imageFetch = this.fetch;
                synchronized (imageFetch) {
                    this.renderer = null;
                    if (!this.status.equals((Object)Status.LOADING)) {
                        return;
                    }
                    if (isVideo.booleanValue()) {
                        this.video = true;
                        this.exception = null;
                        this.status = Status.READY;
                    } else {
                        this.exception = exception;
                        this.status = Status.FAILED;
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (!this.status.equals((Object)Status.READY) && !this.status.equals((Object)Status.FAILED)) {
                return;
            }
            this.status = Status.WAITING;
            this.exception = null;
            ImageRenderer imageRenderer = this.renderer;
            this.renderer = null;
            if (imageRenderer != null) {
                this.renderThreadEx.execute(imageRenderer::release);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (this.uses.get() > 0) {
                WaterMedia.LOGGER.warn(ImageAPI.IT, "Cache of '{}' is released with {} usages remaining", (Object)this.uri, (Object)this.uses.get());
            }
            ImageRenderer imageRenderer = this.renderer;
            this.renderer = null;
            if (imageRenderer != null) {
                this.releaseListeners.forEach(consumer -> consumer.accept(imageRenderer));
                this.renderThreadEx.execute(imageRenderer::release);
            }
            this.status = Status.FORGOTTEN;
            CACHE.remove(this.uri);
        }
    }

    public static enum Status {
        WAITING,
        LOADING,
        READY,
        FORGOTTEN,
        FAILED;

    }
}

