/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.player.videolan;

import com.sun.jna.Platform;
import java.net.URI;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.network.NetworkAPI;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.core.tools.ThreadTool;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.media.InfoApi;
import org.watermedia.videolan4j.media.MediaSlavePriority;
import org.watermedia.videolan4j.media.MediaSlaveType;
import org.watermedia.videolan4j.media.MediaType;
import org.watermedia.videolan4j.player.base.EmbededMediaPlayerEventListener;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.base.State;
import org.watermedia.videolan4j.player.component.CallbackMediaPlayerComponent;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;

public abstract class BasePlayer {
    protected static final Marker IT = MarkerManager.getMarker((String)"BasePlayer");
    protected static final WaterMediaPlayerEventListener LISTENER = new WaterMediaPlayerEventListener();
    protected URI url;
    protected URI audioUrl;
    @Deprecated
    private CallbackMediaPlayerComponent raw;
    protected boolean live = false;
    protected ReentrantLock lock = new ReentrantLock();

    @Deprecated
    public CallbackMediaPlayerComponent raw() {
        return this.raw;
    }

    protected BasePlayer(MediaPlayerFactory factory, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        this.init(factory, renderCallback, bufferFormatCallback, cleanupCallback);
    }

    protected BasePlayer() {
    }

    protected void init(MediaPlayerFactory factory, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        if (PlayerAPI.isReady() && this.raw == null) {
            if (factory == null) {
                factory = PlayerAPI.getFactory();
            }
            this.raw = new CallbackMediaPlayerComponent(factory, true, renderCallback, bufferFormatCallback, cleanupCallback);
            this.raw.mediaPlayer().input().enableKeyInputHandling(false);
            this.raw.mediaPlayer().input().enableMouseInputHandling(false);
            this.raw.mediaPlayer().events().addMediaPlayerEventListener(LISTENER);
        } else {
            WaterMedia.LOGGER.error(IT, "Failed to create raw player because VLC is not loaded");
            this.raw = null;
        }
    }

    private boolean rpa(URI url) {
        if (this.raw == null) {
            return false;
        }
        try {
            AbstractPatch.Result result = NetworkAPI.patch(url);
            if (result == null) {
                throw new IllegalArgumentException("Invalid URL");
            }
            this.url = result.uri;
            this.audioUrl = result.audioUrl;
            this.live = result.assumeStream;
            return true;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to load player", (Throwable)e);
            return false;
        }
    }

    public void start(URI url) {
        this.start(url, new String[0]);
    }

    public void start(URI url, String[] vlcArgs) {
        ThreadTool.thread(() -> {
            this.lock.lock();
            if (this.rpa(url)) {
                if (this.audioUrl != null) {
                    this.raw.mediaPlayer().media().prepare(this.url, vlcArgs);
                    this.raw.mediaPlayer().media().slaves().add(MediaSlaveType.AUDIO, MediaSlavePriority.HIGHEST, this.audioUrl.toString());
                    this.raw.mediaPlayer().controls().start();
                } else {
                    this.raw.mediaPlayer().media().start(this.url, vlcArgs);
                }
            }
            this.lock.unlock();
        });
    }

    public void startPaused(URI url) {
        this.startPaused(url, new String[0]);
    }

    public void startPaused(URI url, String[] vlcArgs) {
        ThreadTool.thread(() -> {
            this.lock.lock();
            if (this.rpa(url)) {
                if (this.audioUrl != null) {
                    this.raw.mediaPlayer().media().prepare(this.url, vlcArgs);
                    if (!this.raw.mediaPlayer().media().slaves().add(MediaSlaveType.AUDIO, MediaSlavePriority.HIGHEST, this.audioUrl.toString())) {
                        WaterMedia.LOGGER.warn(IT, "Failed to add audio slave {} for {}", (Object)this.audioUrl.toString(), (Object)this.url.toString());
                    }
                    this.raw.mediaPlayer().controls().start();
                } else {
                    this.raw.mediaPlayer().media().start(this.url, vlcArgs);
                }
            }
            this.lock.unlock();
        });
    }

    public void resume() {
        this.play();
    }

    public void play() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().play();
    }

    public void pause() {
        if (this.raw == null) {
            return;
        }
        if (this.raw.mediaPlayer().status().canPause()) {
            this.raw.mediaPlayer().controls().pause();
        }
    }

    public void togglePlayback() {
        if (this.raw == null) {
            return;
        }
        if (this.isPaused()) {
            this.raw.mediaPlayer().controls().play();
        } else if (this.isPlaying()) {
            this.raw.mediaPlayer().controls().pause();
        }
    }

    public void setPauseMode(boolean pauseMode) {
        if (this.raw == null) {
            return;
        }
        if (this.raw.mediaPlayer().status().canPause()) {
            this.raw.mediaPlayer().controls().setPause(pauseMode);
        }
    }

    public void stop() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().stop();
    }

    public boolean isSafeUse() {
        return !this.lock.isLocked();
    }

    public String getStateName() {
        return this.raw.mediaPlayer().status().state().name();
    }

    public boolean isWaiting() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.NOTHING_SPECIAL);
    }

    public boolean isLoading() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.OPENING);
    }

    public boolean isBuffering() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.BUFFERING);
    }

    public boolean isReady() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isPlayable();
    }

    public boolean isPaused() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.PAUSED);
    }

    public boolean isStopped() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.STOPPED);
    }

    public boolean isEnded() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.ENDED);
    }

    public boolean isMuted() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().audio().isMute();
    }

    public boolean isBroken() {
        if (this.raw == null) {
            return true;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.ERROR);
    }

    public boolean isValid() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().media().isValid();
    }

    public boolean isPlaying() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isPlaying();
    }

    public boolean isLive() {
        if (this.live) {
            return true;
        }
        InfoApi info = this.raw.mediaPlayer().media().info();
        if (info != null) {
            return info.type().equals((Object)MediaType.STREAM);
        }
        return false;
    }

    public boolean isSeekAble() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isSeekable();
    }

    public void seekTo(long time) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setTime(time);
    }

    public void seekFastTo(long ticks) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setTime(ticks);
    }

    public void foward() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().skipTime(5000L);
    }

    public void rewind() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().skipTime(-5000L);
    }

    public void setSpeed(float rate) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setRate(rate);
    }

    public int getVolume() {
        if (this.raw == null) {
            return 0;
        }
        return this.raw.mediaPlayer().audio().volume();
    }

    public void setVolume(int volume) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setVolume(volume);
        if (volume == 0 && !this.raw.mediaPlayer().audio().isMute()) {
            this.raw.mediaPlayer().audio().setMute(true);
        } else if (volume > 0 && this.raw.mediaPlayer().audio().isMute()) {
            this.raw.mediaPlayer().audio().setMute(false);
        }
    }

    public void mute() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(true);
    }

    public void unmute() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(false);
    }

    public void setMuteMode(boolean mode) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(mode);
    }

    public long getDuration() {
        if (this.raw == null) {
            return 0L;
        }
        if (!this.isValid() || Platform.isLinux() && this.isStopped()) {
            return 0L;
        }
        return this.raw.mediaPlayer().status().length();
    }

    public long getMediaInfoDuration() {
        if (this.raw == null) {
            return 0L;
        }
        InfoApi info = this.raw.mediaPlayer().media().info();
        if (info != null) {
            return info.duration();
        }
        return 0L;
    }

    public long getTime() {
        if (this.raw == null) {
            return 0L;
        }
        return this.raw.mediaPlayer().status().time();
    }

    public boolean getRepeatMode() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().controls().getRepeat();
    }

    public void setRepeatMode(boolean repeatMode) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setRepeat(repeatMode);
    }

    public void release() {
        if (this.raw == null) {
            return;
        }
        ThreadTool.thread(() -> {
            this.lock.lock();
            CallbackMediaPlayerComponent rawRef = this.raw;
            this.raw = null;
            if (rawRef == null) {
                return;
            }
            rawRef.mediaPlayer().release();
            this.lock.unlock();
        });
    }

    protected static final class WaterMediaPlayerEventListener
    extends EmbededMediaPlayerEventListener {
        protected WaterMediaPlayerEventListener() {
        }

        @Override
        public void buffering(MediaPlayer mediaPlayer, float newCache) {
            if (newCache >= 100.0f) {
                mediaPlayer.submit(() -> {
                    mediaPlayer.audio().enforceVolume();
                    int volume = mediaPlayer.audio().masterVolume();
                    if (volume == 0 && !mediaPlayer.audio().isMute()) {
                        mediaPlayer.audio().setMute(true);
                    } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                        mediaPlayer.audio().setMute(false);
                    }
                });
            }
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
            });
        }

        @Override
        public void paused(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
            });
        }

        @Override
        public void mediaPlayerReady(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
                if (mediaPlayer.media().info().duration() < 500L) {
                    mediaPlayer.controls().pause();
                }
            });
        }
    }
}

