/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.factory;

import com.sun.jna.StringArray;
import java.util.Collection;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.discovery.NativeDiscovery;
import org.watermedia.videolan4j.factory.ApplicationApi;
import org.watermedia.videolan4j.factory.AudioApi;
import org.watermedia.videolan4j.factory.DialogsApi;
import org.watermedia.videolan4j.factory.EqualizerApi;
import org.watermedia.videolan4j.factory.MediaApi;
import org.watermedia.videolan4j.factory.MediaDiscovererApi;
import org.watermedia.videolan4j.factory.MediaPlayerApi;
import org.watermedia.videolan4j.factory.NativeLibraryMappingException;
import org.watermedia.videolan4j.factory.RendererApi;
import org.watermedia.videolan4j.factory.VideoSurfaceApi;
import org.watermedia.videolan4j.support.eventmanager.TaskExecutor;

public class MediaPlayerFactory {
    protected final libvlc_instance_t libvlcInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private final ApplicationApi applicationApi;
    private final AudioApi audioApi;
    private final DialogsApi dialogsApi;
    private final MediaDiscovererApi mediaDiscovererApi;
    private final EqualizerApi equalizerApi;
    private final MediaPlayerApi mediaPlayerApi;
    private final MediaApi mediaApi;
    private final RendererApi rendererApi;
    private final VideoSurfaceApi videoSurfaceApi;

    public MediaPlayerFactory(String ... libvlcArgs) {
        try {
            if (!NativeDiscovery.start()) {
                throw new IllegalStateException("VideoLAN is not properly discovered");
            }
        }
        catch (NoClassDefFoundError e) {
            throw new NativeLibraryMappingException("Failed to properly initialise the native library", e);
        }
        this.libvlcInstance = this.newLibVlcInstance(libvlcArgs != null ? libvlcArgs : new String[]{});
        this.applicationApi = new ApplicationApi(this);
        this.audioApi = new AudioApi(this);
        this.dialogsApi = new DialogsApi(this);
        this.mediaDiscovererApi = new MediaDiscovererApi(this);
        this.equalizerApi = new EqualizerApi(this);
        this.mediaPlayerApi = new MediaPlayerApi(this);
        this.mediaApi = new MediaApi(this);
        this.rendererApi = new RendererApi(this);
        this.videoSurfaceApi = new VideoSurfaceApi(this);
    }

    public MediaPlayerFactory(Collection<String> libvlcArgs) {
        this(libvlcArgs.toArray(new String[0]));
    }

    private libvlc_instance_t newLibVlcInstance(String ... libvlcArgs) {
        libvlc_instance_t result = LibVlc.libvlc_new(libvlcArgs.length, new StringArray(libvlcArgs));
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Failed to get a new native library instance");
    }

    public final ApplicationApi application() {
        return this.applicationApi;
    }

    public final AudioApi audio() {
        return this.audioApi;
    }

    public final DialogsApi dialogs() {
        return this.dialogsApi;
    }

    public final MediaDiscovererApi mediaDiscoverers() {
        return this.mediaDiscovererApi;
    }

    public final EqualizerApi equalizer() {
        return this.equalizerApi;
    }

    public final MediaPlayerApi mediaPlayers() {
        return this.mediaPlayerApi;
    }

    public final MediaApi media() {
        return this.mediaApi;
    }

    public final RendererApi renderers() {
        return this.rendererApi;
    }

    public final VideoSurfaceApi videoSurfaces() {
        return this.videoSurfaceApi;
    }

    public final void submit(Runnable r) {
        this.executor.submit(r);
    }

    public final void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.applicationApi.release();
        this.audioApi.release();
        this.dialogsApi.release();
        this.mediaDiscovererApi.release();
        this.equalizerApi.release();
        this.mediaPlayerApi.release();
        this.mediaApi.release();
        this.rendererApi.release();
        this.videoSurfaceApi.release();
        LibVlc.libvlc_release(this.libvlcInstance);
        this.onAfterRelease();
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }
}

